/*
 * Decompiled with CFR 0.152.
 */
package com.github.mlk.junit.rules;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.regex.Pattern;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;

public class NativeLibraryRule
extends ExternalResource {
    private TemporaryFolder tempLibFolder;
    private final Pattern matcher;

    public NativeLibraryRule(Pattern matcher) {
        this.matcher = matcher;
        this.tempLibFolder = new TemporaryFolder();
    }

    public NativeLibraryRule() {
        this(Pattern.compile(".*"));
    }

    private void copyNativeLibraries() throws IOException {
        String[] classPathElements;
        String classPath = System.getProperty("java.class.path", ".");
        for (String element : classPathElements = classPath.split(System.getProperty("path.separator"))) {
            String tmp = element.toLowerCase(Locale.UK);
            if (!this.matcher.matcher(tmp).matches() || !tmp.endsWith("dll") && !tmp.endsWith("so") && !tmp.endsWith("dylib")) continue;
            File currentFile = new File(element);
            Files.copy(Paths.get(currentFile.toURI()), Paths.get(new File(this.tempLibFolder.getRoot(), currentFile.getName()).toURI()), new CopyOption[0]);
        }
    }

    public File getNativeLibrariesFolder() {
        return this.tempLibFolder.getRoot();
    }

    protected void before() throws Throwable {
        this.tempLibFolder.create();
        this.copyNativeLibraries();
    }

    protected void after() {
        this.tempLibFolder.delete();
    }
}

