/*
 * Decompiled with CFR 0.152.
 */
package com.github.mlk.junit.rules;

import com.github.mlk.junit.rules.DatabaseRule;
import com.github.mlk.junit.rules.Helper;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.distribution.IVersion;
import org.junit.rules.ExternalResource;
import ru.yandex.qatools.embed.postgresql.PostgresExecutable;
import ru.yandex.qatools.embed.postgresql.PostgresProcess;
import ru.yandex.qatools.embed.postgresql.PostgresStarter;
import ru.yandex.qatools.embed.postgresql.config.AbstractPostgresConfig;
import ru.yandex.qatools.embed.postgresql.config.PostgresConfig;
import ru.yandex.qatools.embed.postgresql.distribution.Version;

public class PostgresRule
extends ExternalResource
implements DatabaseRule {
    private PostgresProcess postgresRuntime;
    private final int defaultPort;
    private final String databaseName;
    private final String username;
    private final String password;
    private final IVersion version;
    private int port;

    public PostgresRule(int defaultPort, String databaseName, String username, String password, IVersion version) {
        this.defaultPort = defaultPort;
        this.databaseName = databaseName;
        this.username = username;
        this.password = password;
        this.version = version;
    }

    public PostgresRule() {
        this(-1, "postgres", "postgres", "postgres", (IVersion)Version.Main.V9_4);
    }

    @Override
    public String getDatasourceUrl() {
        return "jdbc:postgresql://localhost:" + this.port + "/" + this.databaseName;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void before() throws Throwable {
        this.port = this.defaultPort;
        if (this.port < 0) {
            this.port = Helper.findRandomOpenPortOnAllLocalInterfaces();
        }
        this.postgresRuntime = (PostgresProcess)((PostgresExecutable)PostgresStarter.getDefaultInstance().prepare((IExecutableProcessConfig)new PostgresConfig(this.version, new AbstractPostgresConfig.Net("localhost", this.port), new AbstractPostgresConfig.Storage(this.databaseName), new AbstractPostgresConfig.Timeout(30000L), new AbstractPostgresConfig.Credentials(this.username, this.password)))).start();
    }

    @Override
    public void after() {
        this.postgresRuntime.stop();
    }
}

