/*
 * Decompiled with CFR 0.152.
 */
package com.github.mlk.junit.rules;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.github.mlk.junit.rules.Helper;
import io.findify.s3mock.S3Mock;
import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Set;
import org.junit.rules.ExternalResource;

public class S3MockRule
extends ExternalResource {
    private S3Mock s3Mock;
    private InetSocketAddress localAddress;
    private AmazonS3 amazonS3;
    private final Set<String> buckets;
    private final Set<FakeFile> files;

    public S3MockRule() {
        this(Collections.emptySet(), Collections.emptySet());
    }

    public S3MockRule(Set<String> buckets, Set<FakeFile> files) {
        this.buckets = buckets;
        this.files = files;
    }

    protected void before() throws Throwable {
        this.s3Mock = S3Mock.create((int)Helper.findRandomOpenPortOnAllLocalInterfaces());
        this.localAddress = this.s3Mock.start().localAddress();
        this.amazonS3 = (AmazonS3)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.getEndpoint(), "eu-west-1"))).build();
        this.buckets.forEach(arg_0 -> ((AmazonS3)this.amazonS3).createBucket(arg_0));
        this.files.forEach(fakeFile -> this.amazonS3.putObject(((FakeFile)fakeFile).bucket, ((FakeFile)fakeFile).name, ((FakeFile)fakeFile).content));
    }

    protected void after() {
        if (this.localAddress != null) {
            this.s3Mock.stop();
        }
    }

    public String getEndpoint() {
        return "http://127.0.0.1:" + this.localAddress.getPort();
    }

    public AmazonS3 getAmazonS3Client() {
        return this.amazonS3;
    }

    static final class FakeFile {
        private final String bucket;
        private final String name;
        private final String content;

        @ConstructorProperties(value={"bucket", "name", "content"})
        public FakeFile(String bucket, String name, String content) {
            this.bucket = bucket;
            this.name = name;
            this.content = content;
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getName() {
            return this.name;
        }

        public String getContent() {
            return this.content;
        }

        public String toString() {
            return "S3MockRule.FakeFile(bucket=" + this.getBucket() + ", name=" + this.getName() + ", content=" + this.getContent() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FakeFile)) {
                return false;
            }
            FakeFile other = (FakeFile)o;
            String this$bucket = this.getBucket();
            String other$bucket = other.getBucket();
            if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bucket = this.getBucket();
            result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }
    }
}

