/*
 * Decompiled with CFR 0.152.
 */
package com.github.mlk.junit.rules;

import com.github.mlk.junit.rules.Helper;
import java.io.File;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Collections;
import java.util.function.Supplier;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.common.keyprovider.ClassLoadableResourceKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.hostbased.HostBasedAuthenticator;
import org.apache.sshd.server.auth.hostbased.StaticHostBasedAuthenticator;
import org.apache.sshd.server.auth.pubkey.AcceptAllPublickeyAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.auth.pubkey.UserAuthPublicKeyFactory;
import org.apache.sshd.server.scp.ScpCommandFactory;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;
import org.junit.rules.ExternalResource;

public class SftpRule
extends ExternalResource {
    private final Supplier<File> currentFolder;
    private SshServer sshd;

    public SftpRule(Supplier<File> currentFolder) {
        this.currentFolder = currentFolder;
    }

    protected void before() throws Throwable {
        this.sshd = SshServer.setUpDefaultServer();
        this.sshd.setPort(Helper.findRandomOpenPortOnAllLocalInterfaces());
        this.sshd.setKeyPairProvider((KeyPairProvider)new ClassLoadableResourceKeyPairProvider(((Object)((Object)this)).getClass().getClassLoader(), "server_key"));
        this.sshd.setCommandFactory((CommandFactory)new ScpCommandFactory());
        this.sshd.setSubsystemFactories(Collections.singletonList(new SftpSubsystemFactory()));
        this.sshd.setUserAuthFactories(Collections.singletonList(new UserAuthPublicKeyFactory()));
        this.sshd.setHost("localhost");
        this.sshd.setPublickeyAuthenticator((PublickeyAuthenticator)AcceptAllPublickeyAuthenticator.INSTANCE);
        this.sshd.setHostBasedAuthenticator((HostBasedAuthenticator)new StaticHostBasedAuthenticator(true));
        VirtualFileSystemFactory fileSystemFactory = new VirtualFileSystemFactory();
        fileSystemFactory.setDefaultHomeDir(this.currentFolder.get().toPath());
        this.sshd.setFileSystemFactory((FileSystemFactory)fileSystemFactory);
        this.sshd.start();
    }

    protected void after() {
        try {
            this.sshd.stop();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getPort() {
        return this.sshd.getPort();
    }

    @Deprecated
    public PublicKey getPublicKey() {
        return this.getHostsPublicKey();
    }

    public PublicKey getHostsPublicKey() {
        return ((KeyPair)this.sshd.getKeyPairProvider().loadKeys().iterator().next()).getPublic();
    }
}

