/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc;

import com.github.msemys.esjc.ResolvedEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

abstract class AbstractEventsIterator<T, R>
implements Iterator<ResolvedEvent> {
    private final Function<T, CompletableFuture<R>> reader;
    private T cursor;
    private Iterator<ResolvedEvent> iterator;
    private boolean endOfStream;

    AbstractEventsIterator(T cursor, Function<T, CompletableFuture<R>> reader) {
        this.cursor = cursor;
        this.reader = reader;
    }

    @Override
    public boolean hasNext() {
        return this.iterator().hasNext();
    }

    @Override
    public ResolvedEvent next() {
        ResolvedEvent event = this.iterator().next();
        if (!this.iterator.hasNext()) {
            this.iterator = this.endOfStream ? Collections.emptyIterator() : null;
        }
        return event;
    }

    private Iterator<ResolvedEvent> iterator() {
        if (this.iterator == null) {
            this.onBatchReceived(this.reader.apply(this.cursor).join());
        }
        return this.iterator;
    }

    protected void onBatchReceived(R slice) {
        this.cursor = this.getNextCursor(slice);
        this.iterator = this.getEvents(slice).iterator();
        this.endOfStream = this.isEndOfStream(slice);
    }

    protected abstract T getNextCursor(R var1);

    protected abstract List<ResolvedEvent> getEvents(R var1);

    protected abstract boolean isEndOfStream(R var1);
}

