/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc;

import com.github.msemys.esjc.ResolvedEvent;
import com.github.msemys.esjc.util.Preconditions;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;

abstract class AbstractEventsSpliterator<T, R>
implements Spliterator<ResolvedEvent> {
    private static final int CHARACTERISTICS = 17744;
    private final Function<T, CompletableFuture<R>> reader;
    private T cursor;
    private Spliterator<ResolvedEvent> spliterator;
    private boolean endOfStream;
    private long estimate = Long.MAX_VALUE;

    AbstractEventsSpliterator(T cursor, Function<T, CompletableFuture<R>> reader) {
        this.cursor = cursor;
        this.reader = reader;
    }

    @Override
    public boolean tryAdvance(Consumer<? super ResolvedEvent> action) {
        Preconditions.checkNotNull(action, "action is null");
        if (this.spliterator == null) {
            this.spliterator = this.nextBatch().spliterator();
        }
        if (this.spliterator.tryAdvance(action)) {
            return true;
        }
        if (!this.endOfStream) {
            this.spliterator = this.nextBatch().spliterator();
            return this.spliterator.tryAdvance(action);
        }
        this.spliterator = Spliterators.emptySpliterator();
        return false;
    }

    @Override
    public Spliterator<ResolvedEvent> trySplit() {
        if (!this.endOfStream) {
            if (this.spliterator == null) {
                return this.nextBatch().spliterator();
            }
            Spliterator<ResolvedEvent> currentSpliterator = this.spliterator;
            this.spliterator = null;
            return currentSpliterator;
        }
        if (this.spliterator == null) {
            this.spliterator = Spliterators.emptySpliterator();
        }
        return null;
    }

    @Override
    public long estimateSize() {
        return this.estimate;
    }

    @Override
    public int characteristics() {
        return 17744;
    }

    private List<ResolvedEvent> nextBatch() {
        R slice = this.reader.apply(this.cursor).join();
        this.onBatchReceived(slice);
        List<ResolvedEvent> events = this.getEvents(slice);
        this.estimate = events.size();
        return events;
    }

    protected void onBatchReceived(R slice) {
        this.cursor = this.getNextCursor(slice);
        this.endOfStream = this.isEndOfStream(slice);
    }

    protected abstract T getNextCursor(R var1);

    protected abstract List<ResolvedEvent> getEvents(R var1);

    protected abstract boolean isEndOfStream(R var1);
}

