/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc;

import com.github.msemys.esjc.util.Numbers;
import com.github.msemys.esjc.util.Preconditions;
import com.github.msemys.esjc.util.Ranges;

public class CatchUpSubscriptionSettings {
    public static final CatchUpSubscriptionSettings DEFAULT = CatchUpSubscriptionSettings.newBuilder().build();
    public final int maxLiveQueueSize;
    public final boolean resolveLinkTos;
    public final int readBatchSize;

    private CatchUpSubscriptionSettings(Builder builder) {
        this.maxLiveQueueSize = builder.maxLiveQueueSize;
        this.resolveLinkTos = builder.resolveLinkTos;
        this.readBatchSize = builder.readBatchSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CatchUpSubscriptionSettings{");
        sb.append("maxLiveQueueSize=").append(this.maxLiveQueueSize);
        sb.append(", resolveLinkTos=").append(this.resolveLinkTos);
        sb.append(", readBatchSize=").append(this.readBatchSize);
        sb.append('}');
        return sb.toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Integer maxLiveQueueSize;
        private Boolean resolveLinkTos;
        private Integer readBatchSize;

        public Builder maxLiveQueueSize(int maxLiveQueueSize) {
            this.maxLiveQueueSize = maxLiveQueueSize;
            return this;
        }

        public Builder resolveLinkTos(boolean resolveLinkTos) {
            this.resolveLinkTos = resolveLinkTos;
            return this;
        }

        public Builder readBatchSize(int readBatchSize) {
            this.readBatchSize = readBatchSize;
            return this;
        }

        public CatchUpSubscriptionSettings build() {
            if (this.maxLiveQueueSize == null) {
                this.maxLiveQueueSize = 10000;
            } else {
                Preconditions.checkArgument(Numbers.isPositive(this.maxLiveQueueSize), "maxLiveQueueSize should be positive");
            }
            if (this.resolveLinkTos == null) {
                this.resolveLinkTos = false;
            }
            if (this.readBatchSize == null) {
                this.readBatchSize = 500;
            } else {
                Preconditions.checkArgument(Ranges.BATCH_SIZE_RANGE.contains(this.readBatchSize), "readBatchSize is out of range. Allowed range: %s.", Ranges.BATCH_SIZE_RANGE.toString());
            }
            return new CatchUpSubscriptionSettings(this);
        }
    }
}

