/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc;

import com.github.msemys.esjc.util.EmptyArrays;
import com.github.msemys.esjc.util.Preconditions;
import com.github.msemys.esjc.util.Strings;
import java.util.UUID;

public class EventData {
    public final UUID eventId;
    public final String type;
    public final boolean isJsonData;
    public final byte[] data;
    public final boolean isJsonMetadata;
    public final byte[] metadata;

    private EventData(Builder builder) {
        this.eventId = builder.eventId;
        this.type = builder.type;
        this.isJsonData = builder.isJsonData;
        this.data = builder.data;
        this.isJsonMetadata = builder.isJsonMetadata;
        this.metadata = builder.metadata;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private UUID eventId;
        private String type;
        private boolean isJsonData;
        private byte[] data;
        private boolean isJsonMetadata;
        private byte[] metadata;

        private Builder() {
        }

        public Builder eventId(UUID eventId) {
            this.eventId = eventId;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder data(String data) {
            return this.data(Strings.toBytes(data));
        }

        public Builder data(byte[] data) {
            this.data = data;
            this.isJsonData = false;
            return this;
        }

        public Builder jsonData(String data) {
            return this.jsonData(Strings.toBytes(data));
        }

        public Builder jsonData(byte[] data) {
            this.data = data;
            this.isJsonData = true;
            return this;
        }

        public Builder metadata(String metadata) {
            return this.metadata(Strings.toBytes(metadata));
        }

        public Builder metadata(byte[] metadata) {
            this.metadata = metadata;
            this.isJsonMetadata = false;
            return this;
        }

        public Builder jsonMetadata(String metadata) {
            return this.jsonMetadata(Strings.toBytes(metadata));
        }

        public Builder jsonMetadata(byte[] metadata) {
            this.metadata = metadata;
            this.isJsonMetadata = true;
            return this;
        }

        public Builder linkTo(long eventNumber, String stream) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(stream), "stream is null or empty");
            return this.type("$>").data(eventNumber + "@" + stream);
        }

        public EventData build() {
            if (this.eventId == null) {
                this.eventId = UUID.randomUUID();
            }
            Preconditions.checkNotNull(this.type, "type is null");
            if (this.data == null) {
                this.data = EmptyArrays.EMPTY_BYTES;
            }
            if (this.metadata == null) {
                this.metadata = EmptyArrays.EMPTY_BYTES;
            }
            return new EventData(this);
        }
    }
}

