/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc;

import com.github.msemys.esjc.AllEventsSlice;
import com.github.msemys.esjc.CatchUpSubscription;
import com.github.msemys.esjc.CatchUpSubscriptionListener;
import com.github.msemys.esjc.CatchUpSubscriptionSettings;
import com.github.msemys.esjc.DeleteResult;
import com.github.msemys.esjc.EventData;
import com.github.msemys.esjc.EventReadResult;
import com.github.msemys.esjc.EventStoreListener;
import com.github.msemys.esjc.PersistentSubscription;
import com.github.msemys.esjc.PersistentSubscriptionCreateResult;
import com.github.msemys.esjc.PersistentSubscriptionDeleteResult;
import com.github.msemys.esjc.PersistentSubscriptionListener;
import com.github.msemys.esjc.PersistentSubscriptionSettings;
import com.github.msemys.esjc.PersistentSubscriptionUpdateResult;
import com.github.msemys.esjc.Position;
import com.github.msemys.esjc.RawStreamMetadataResult;
import com.github.msemys.esjc.ResolvedEvent;
import com.github.msemys.esjc.Settings;
import com.github.msemys.esjc.StreamEventsSlice;
import com.github.msemys.esjc.StreamMetadata;
import com.github.msemys.esjc.StreamMetadataResult;
import com.github.msemys.esjc.Subscription;
import com.github.msemys.esjc.SystemSettings;
import com.github.msemys.esjc.Transaction;
import com.github.msemys.esjc.UserCredentials;
import com.github.msemys.esjc.VolatileSubscriptionListener;
import com.github.msemys.esjc.WriteAttemptResult;
import com.github.msemys.esjc.WriteResult;
import com.github.msemys.esjc.util.Preconditions;
import com.github.msemys.esjc.util.Strings;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

public interface EventStore {
    public Settings settings();

    public void connect();

    public void disconnect();

    public void shutdown();

    default public CompletableFuture<DeleteResult> deleteStream(String stream, long expectedVersion) {
        return this.deleteStream(stream, expectedVersion, false, null);
    }

    default public CompletableFuture<DeleteResult> deleteStream(String stream, long expectedVersion, UserCredentials userCredentials) {
        return this.deleteStream(stream, expectedVersion, false, userCredentials);
    }

    default public CompletableFuture<DeleteResult> deleteStream(String stream, long expectedVersion, boolean hardDelete) {
        return this.deleteStream(stream, expectedVersion, hardDelete, null);
    }

    public CompletableFuture<DeleteResult> deleteStream(String var1, long var2, boolean var4, UserCredentials var5);

    default public CompletableFuture<WriteResult> appendToStream(String stream, long expectedVersion, EventData event) {
        return this.appendToStream(stream, expectedVersion, event, null);
    }

    default public CompletableFuture<WriteResult> appendToStream(String stream, long expectedVersion, EventData event, UserCredentials userCredentials) {
        return this.appendToStream(stream, expectedVersion, Collections.singletonList(event), userCredentials);
    }

    default public CompletableFuture<WriteResult> appendToStream(String stream, long expectedVersion, Iterable<EventData> events) {
        return this.appendToStream(stream, expectedVersion, events, null);
    }

    public CompletableFuture<WriteResult> appendToStream(String var1, long var2, Iterable<EventData> var4, UserCredentials var5);

    default public CompletableFuture<WriteAttemptResult> tryAppendToStream(String stream, long expectedVersion, EventData event) {
        return this.tryAppendToStream(stream, expectedVersion, event, null);
    }

    default public CompletableFuture<WriteAttemptResult> tryAppendToStream(String stream, long expectedVersion, EventData event, UserCredentials userCredentials) {
        return this.tryAppendToStream(stream, expectedVersion, Collections.singletonList(event), userCredentials);
    }

    default public CompletableFuture<WriteAttemptResult> tryAppendToStream(String stream, long expectedVersion, Iterable<EventData> events) {
        return this.tryAppendToStream(stream, expectedVersion, events, null);
    }

    public CompletableFuture<WriteAttemptResult> tryAppendToStream(String var1, long var2, Iterable<EventData> var4, UserCredentials var5);

    default public CompletableFuture<Transaction> startTransaction(String stream, long expectedVersion) {
        return this.startTransaction(stream, expectedVersion, null);
    }

    public CompletableFuture<Transaction> startTransaction(String var1, long var2, UserCredentials var4);

    default public Transaction continueTransaction(long transactionId) {
        return this.continueTransaction(transactionId, null);
    }

    public Transaction continueTransaction(long var1, UserCredentials var3);

    default public CompletableFuture<EventReadResult> readEvent(String stream, long eventNumber, boolean resolveLinkTos) {
        return this.readEvent(stream, eventNumber, resolveLinkTos, null);
    }

    public CompletableFuture<EventReadResult> readEvent(String var1, long var2, boolean var4, UserCredentials var5);

    default public CompletableFuture<StreamEventsSlice> readStreamEventsForward(String stream, long eventNumber, int maxCount, boolean resolveLinkTos) {
        return this.readStreamEventsForward(stream, eventNumber, maxCount, resolveLinkTos, null);
    }

    public CompletableFuture<StreamEventsSlice> readStreamEventsForward(String var1, long var2, int var4, boolean var5, UserCredentials var6);

    default public CompletableFuture<StreamEventsSlice> readStreamEventsBackward(String stream, long eventNumber, int maxCount, boolean resolveLinkTos) {
        return this.readStreamEventsBackward(stream, eventNumber, maxCount, resolveLinkTos, null);
    }

    public CompletableFuture<StreamEventsSlice> readStreamEventsBackward(String var1, long var2, int var4, boolean var5, UserCredentials var6);

    default public CompletableFuture<AllEventsSlice> readAllEventsForward(Position position, int maxCount, boolean resolveLinkTos) {
        return this.readAllEventsForward(position, maxCount, resolveLinkTos, null);
    }

    public CompletableFuture<AllEventsSlice> readAllEventsForward(Position var1, int var2, boolean var3, UserCredentials var4);

    default public CompletableFuture<AllEventsSlice> readAllEventsBackward(Position position, int maxCount, boolean resolveLinkTos) {
        return this.readAllEventsBackward(position, maxCount, resolveLinkTos, null);
    }

    public CompletableFuture<AllEventsSlice> readAllEventsBackward(Position var1, int var2, boolean var3, UserCredentials var4);

    default public Iterator<ResolvedEvent> iterateStreamEventsForward(String stream, long eventNumber, int batchSize, boolean resolveLinkTos) {
        return this.iterateStreamEventsForward(stream, eventNumber, batchSize, resolveLinkTos, null);
    }

    public Iterator<ResolvedEvent> iterateStreamEventsForward(String var1, long var2, int var4, boolean var5, UserCredentials var6);

    default public Iterator<ResolvedEvent> iterateStreamEventsBackward(String stream, long eventNumber, int batchSize, boolean resolveLinkTos) {
        return this.iterateStreamEventsBackward(stream, eventNumber, batchSize, resolveLinkTos, null);
    }

    public Iterator<ResolvedEvent> iterateStreamEventsBackward(String var1, long var2, int var4, boolean var5, UserCredentials var6);

    default public Iterator<ResolvedEvent> iterateAllEventsForward(Position position, int batchSize, boolean resolveLinkTos) {
        return this.iterateAllEventsForward(position, batchSize, resolveLinkTos, null);
    }

    public Iterator<ResolvedEvent> iterateAllEventsForward(Position var1, int var2, boolean var3, UserCredentials var4);

    default public Iterator<ResolvedEvent> iterateAllEventsBackward(Position position, int batchSize, boolean resolveLinkTos) {
        return this.iterateAllEventsBackward(position, batchSize, resolveLinkTos, null);
    }

    public Iterator<ResolvedEvent> iterateAllEventsBackward(Position var1, int var2, boolean var3, UserCredentials var4);

    default public Stream<ResolvedEvent> streamEventsForward(String stream, long eventNumber, int batchSize, boolean resolveLinkTos) {
        return this.streamEventsForward(stream, eventNumber, batchSize, resolveLinkTos, null);
    }

    public Stream<ResolvedEvent> streamEventsForward(String var1, long var2, int var4, boolean var5, UserCredentials var6);

    default public Stream<ResolvedEvent> streamEventsBackward(String stream, long eventNumber, int batchSize, boolean resolveLinkTos) {
        return this.streamEventsBackward(stream, eventNumber, batchSize, resolveLinkTos, null);
    }

    public Stream<ResolvedEvent> streamEventsBackward(String var1, long var2, int var4, boolean var5, UserCredentials var6);

    default public Stream<ResolvedEvent> streamAllEventsForward(Position position, int batchSize, boolean resolveLinkTos) {
        return this.streamAllEventsForward(position, batchSize, resolveLinkTos, null);
    }

    public Stream<ResolvedEvent> streamAllEventsForward(Position var1, int var2, boolean var3, UserCredentials var4);

    default public Stream<ResolvedEvent> streamAllEventsBackward(Position position, int batchSize, boolean resolveLinkTos) {
        return this.streamAllEventsBackward(position, batchSize, resolveLinkTos, null);
    }

    public Stream<ResolvedEvent> streamAllEventsBackward(Position var1, int var2, boolean var3, UserCredentials var4);

    default public CompletableFuture<Subscription> subscribeToStream(String stream, boolean resolveLinkTos, VolatileSubscriptionListener listener) {
        return this.subscribeToStream(stream, resolveLinkTos, listener, null);
    }

    public CompletableFuture<Subscription> subscribeToStream(String var1, boolean var2, VolatileSubscriptionListener var3, UserCredentials var4);

    default public CompletableFuture<Subscription> subscribeToAll(boolean resolveLinkTos, VolatileSubscriptionListener listener) {
        return this.subscribeToAll(resolveLinkTos, listener, null);
    }

    public CompletableFuture<Subscription> subscribeToAll(boolean var1, VolatileSubscriptionListener var2, UserCredentials var3);

    default public CatchUpSubscription subscribeToStreamFrom(String stream, Long eventNumber, CatchUpSubscriptionSettings settings, CatchUpSubscriptionListener listener) {
        return this.subscribeToStreamFrom(stream, eventNumber, settings, listener, null);
    }

    default public CatchUpSubscription subscribeToStreamFrom(String stream, Long eventNumber, CatchUpSubscriptionListener listener) {
        return this.subscribeToStreamFrom(stream, eventNumber, CatchUpSubscriptionSettings.DEFAULT, listener, null);
    }

    default public CatchUpSubscription subscribeToStreamFrom(String stream, Long eventNumber, CatchUpSubscriptionListener listener, UserCredentials userCredentials) {
        return this.subscribeToStreamFrom(stream, eventNumber, CatchUpSubscriptionSettings.DEFAULT, listener, userCredentials);
    }

    public CatchUpSubscription subscribeToStreamFrom(String var1, Long var2, CatchUpSubscriptionSettings var3, CatchUpSubscriptionListener var4, UserCredentials var5);

    default public CatchUpSubscription subscribeToAllFrom(Position position, CatchUpSubscriptionListener listener) {
        return this.subscribeToAllFrom(position, CatchUpSubscriptionSettings.DEFAULT, listener, null);
    }

    default public CatchUpSubscription subscribeToAllFrom(Position position, CatchUpSubscriptionSettings settings, CatchUpSubscriptionListener listener) {
        return this.subscribeToAllFrom(position, settings, listener, null);
    }

    default public CatchUpSubscription subscribeToAllFrom(Position position, CatchUpSubscriptionListener listener, UserCredentials userCredentials) {
        return this.subscribeToAllFrom(position, CatchUpSubscriptionSettings.DEFAULT, listener, userCredentials);
    }

    public CatchUpSubscription subscribeToAllFrom(Position var1, CatchUpSubscriptionSettings var2, CatchUpSubscriptionListener var3, UserCredentials var4);

    default public CompletableFuture<PersistentSubscription> subscribeToPersistent(String stream, String groupName, PersistentSubscriptionListener listener) {
        return this.subscribeToPersistent(stream, groupName, listener, null, this.settings().persistentSubscriptionBufferSize, this.settings().persistentSubscriptionAutoAck);
    }

    default public CompletableFuture<PersistentSubscription> subscribeToPersistent(String stream, String groupName, PersistentSubscriptionListener listener, UserCredentials userCredentials) {
        return this.subscribeToPersistent(stream, groupName, listener, userCredentials, this.settings().persistentSubscriptionBufferSize, this.settings().persistentSubscriptionAutoAck);
    }

    default public CompletableFuture<PersistentSubscription> subscribeToPersistent(String stream, String groupName, PersistentSubscriptionListener listener, int bufferSize, boolean autoAck) {
        return this.subscribeToPersistent(stream, groupName, listener, null, bufferSize, autoAck);
    }

    default public CompletableFuture<PersistentSubscription> subscribeToPersistent(String stream, String groupName, PersistentSubscriptionListener listener, boolean autoAck) {
        return this.subscribeToPersistent(stream, groupName, listener, null, this.settings().persistentSubscriptionBufferSize, autoAck);
    }

    default public CompletableFuture<PersistentSubscription> subscribeToPersistent(String stream, String groupName, PersistentSubscriptionListener listener, UserCredentials userCredentials, boolean autoAck) {
        return this.subscribeToPersistent(stream, groupName, listener, userCredentials, this.settings().persistentSubscriptionBufferSize, autoAck);
    }

    public CompletableFuture<PersistentSubscription> subscribeToPersistent(String var1, String var2, PersistentSubscriptionListener var3, UserCredentials var4, int var5, boolean var6);

    default public CompletableFuture<PersistentSubscriptionCreateResult> createPersistentSubscription(String stream, String groupName) {
        return this.createPersistentSubscription(stream, groupName, PersistentSubscriptionSettings.DEFAULT, null);
    }

    default public CompletableFuture<PersistentSubscriptionCreateResult> createPersistentSubscription(String stream, String groupName, UserCredentials userCredentials) {
        return this.createPersistentSubscription(stream, groupName, PersistentSubscriptionSettings.DEFAULT, userCredentials);
    }

    default public CompletableFuture<PersistentSubscriptionCreateResult> createPersistentSubscription(String stream, String groupName, PersistentSubscriptionSettings settings) {
        return this.createPersistentSubscription(stream, groupName, settings, null);
    }

    public CompletableFuture<PersistentSubscriptionCreateResult> createPersistentSubscription(String var1, String var2, PersistentSubscriptionSettings var3, UserCredentials var4);

    default public CompletableFuture<PersistentSubscriptionUpdateResult> updatePersistentSubscription(String stream, String groupName, PersistentSubscriptionSettings settings) {
        return this.updatePersistentSubscription(stream, groupName, settings, null);
    }

    public CompletableFuture<PersistentSubscriptionUpdateResult> updatePersistentSubscription(String var1, String var2, PersistentSubscriptionSettings var3, UserCredentials var4);

    default public CompletableFuture<PersistentSubscriptionDeleteResult> deletePersistentSubscription(String stream, String groupName) {
        return this.deletePersistentSubscription(stream, groupName, null);
    }

    public CompletableFuture<PersistentSubscriptionDeleteResult> deletePersistentSubscription(String var1, String var2, UserCredentials var3);

    default public CompletableFuture<WriteResult> setStreamMetadata(String stream, long expectedMetastreamVersion, StreamMetadata metadata) {
        Preconditions.checkNotNull(metadata, "metadata is null");
        return this.setStreamMetadata(stream, expectedMetastreamVersion, Strings.toBytes(metadata.toJson()), null);
    }

    default public CompletableFuture<WriteResult> setStreamMetadata(String stream, long expectedMetastreamVersion, StreamMetadata metadata, UserCredentials userCredentials) {
        Preconditions.checkNotNull(metadata, "metadata is null");
        return this.setStreamMetadata(stream, expectedMetastreamVersion, Strings.toBytes(metadata.toJson()), userCredentials);
    }

    default public CompletableFuture<WriteResult> setStreamMetadata(String stream, long expectedMetastreamVersion, byte[] metadata) {
        return this.setStreamMetadata(stream, expectedMetastreamVersion, metadata, null);
    }

    public CompletableFuture<WriteResult> setStreamMetadata(String var1, long var2, byte[] var4, UserCredentials var5);

    default public CompletableFuture<StreamMetadataResult> getStreamMetadata(String stream) {
        return this.getStreamMetadata(stream, null);
    }

    public CompletableFuture<StreamMetadataResult> getStreamMetadata(String var1, UserCredentials var2);

    default public CompletableFuture<RawStreamMetadataResult> getStreamMetadataAsRawBytes(String stream) {
        return this.getStreamMetadataAsRawBytes(stream, null);
    }

    public CompletableFuture<RawStreamMetadataResult> getStreamMetadataAsRawBytes(String var1, UserCredentials var2);

    default public CompletableFuture<WriteResult> setSystemSettings(SystemSettings settings) {
        return this.setSystemSettings(settings, null);
    }

    public CompletableFuture<WriteResult> setSystemSettings(SystemSettings var1, UserCredentials var2);

    public void addListener(EventStoreListener var1);

    public void removeListener(EventStoreListener var1);
}

