/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc;

import com.github.msemys.esjc.EventStore;
import com.github.msemys.esjc.EventStoreTcp;
import com.github.msemys.esjc.Settings;
import com.github.msemys.esjc.UserCredentials;
import com.github.msemys.esjc.node.EndpointDiscoverer;
import com.github.msemys.esjc.node.EndpointDiscovererFactory;
import com.github.msemys.esjc.node.cluster.ClusterNodeSettings;
import com.github.msemys.esjc.node.single.SingleNodeSettings;
import com.github.msemys.esjc.ssl.SslSettings;
import com.github.msemys.esjc.tcp.TcpSettings;
import com.github.msemys.esjc.util.Preconditions;
import java.io.File;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.function.Function;

public class EventStoreBuilder {
    private final Settings.Builder settingsBuilder;
    private TcpSettings.Builder tcpSettingsBuilder;
    private SingleNodeSettings.Builder singleNodeSettingsBuilder;
    private ClusterNodeSettings.BuilderForDnsDiscoverer clusterNodeUsingDnsSettingsBuilder;
    private ClusterNodeSettings.BuilderForGossipSeedDiscoverer clusterNodeUsingGossipSeedSettingsBuilder;

    private EventStoreBuilder(Settings.Builder settingsBuilder, TcpSettings.Builder tcpSettingsBuilder, SingleNodeSettings.Builder singleNodeSettingsBuilder, ClusterNodeSettings.BuilderForDnsDiscoverer clusterNodeUsingDnsSettingsBuilder, ClusterNodeSettings.BuilderForGossipSeedDiscoverer clusterNodeUsingGossipSeedSettingsBuilder) {
        Preconditions.checkNotNull(settingsBuilder, "settingsBuilder is null");
        this.settingsBuilder = settingsBuilder;
        this.tcpSettingsBuilder = tcpSettingsBuilder;
        this.singleNodeSettingsBuilder = singleNodeSettingsBuilder;
        this.clusterNodeUsingDnsSettingsBuilder = clusterNodeUsingDnsSettingsBuilder;
        this.clusterNodeUsingGossipSeedSettingsBuilder = clusterNodeUsingGossipSeedSettingsBuilder;
    }

    public static EventStoreBuilder newBuilder(Settings settings) {
        Preconditions.checkNotNull(settings, "settings is null");
        Settings.Builder settingsBuilder = Settings.newBuilder().connectionName(settings.connectionName).sslSettings(settings.sslSettings).endpointDiscovererFactory(settings.endpointDiscovererFactory).reconnectionDelay(settings.reconnectionDelay).heartbeatInterval(settings.heartbeatInterval).heartbeatTimeout(settings.heartbeatTimeout).requireMaster(settings.requireMaster).userCredentials(settings.userCredentials).operationTimeout(settings.operationTimeout).operationTimeoutCheckInterval(settings.operationTimeoutCheckInterval).maxOperationQueueSize(settings.maxOperationQueueSize).maxConcurrentOperations(settings.maxConcurrentOperations).maxOperationRetries(settings.maxOperationRetries).maxReconnections(settings.maxReconnections).persistentSubscriptionBufferSize(settings.persistentSubscriptionBufferSize).persistentSubscriptionAutoAck(settings.persistentSubscriptionAutoAck).failOnNoServerResponse(settings.failOnNoServerResponse).disconnectOnTcpChannelError(settings.disconnectOnTcpChannelError).executor(settings.executor);
        SingleNodeSettings.Builder singleNodeSettingsBuilder = null;
        if (settings.singleNodeSettings != null) {
            singleNodeSettingsBuilder = SingleNodeSettings.newBuilder().address(settings.singleNodeSettings.address);
        }
        ClusterNodeSettings.BuilderForDnsDiscoverer clusterNodeUsingDnsSettingsBuilder = null;
        ClusterNodeSettings.BuilderForGossipSeedDiscoverer clusterNodeUsingGossipSeedSettingsBuilder = null;
        if (settings.clusterNodeSettings != null) {
            if (!settings.clusterNodeSettings.gossipSeeds.isEmpty()) {
                clusterNodeUsingGossipSeedSettingsBuilder = ClusterNodeSettings.forGossipSeedDiscoverer().maxDiscoverAttempts(settings.clusterNodeSettings.maxDiscoverAttempts).discoverAttemptInterval(settings.clusterNodeSettings.discoverAttemptInterval).gossipSeeds(settings.clusterNodeSettings.gossipSeeds).gossipTimeout(settings.clusterNodeSettings.gossipTimeout).nodePreference(settings.clusterNodeSettings.nodePreference);
            } else {
                clusterNodeUsingDnsSettingsBuilder = ClusterNodeSettings.forDnsDiscoverer().maxDiscoverAttempts(settings.clusterNodeSettings.maxDiscoverAttempts).discoverAttemptInterval(settings.clusterNodeSettings.discoverAttemptInterval).dns(settings.clusterNodeSettings.dns).externalGossipPort(settings.clusterNodeSettings.externalGossipPort).gossipTimeout(settings.clusterNodeSettings.gossipTimeout).nodePreference(settings.clusterNodeSettings.nodePreference);
            }
        }
        TcpSettings.Builder tcpSettingsBuilder = TcpSettings.newBuilder().connectTimeout(settings.tcpSettings.connectTimeout).closeTimeout(settings.tcpSettings.closeTimeout).keepAlive(settings.tcpSettings.keepAlive).noDelay(settings.tcpSettings.noDelay).sendBufferSize(settings.tcpSettings.sendBufferSize).receiveBufferSize(settings.tcpSettings.receiveBufferSize).writeBufferHighWaterMark(settings.tcpSettings.writeBufferHighWaterMark).writeBufferLowWaterMark(settings.tcpSettings.writeBufferLowWaterMark);
        return new EventStoreBuilder(settingsBuilder, tcpSettingsBuilder, singleNodeSettingsBuilder, clusterNodeUsingDnsSettingsBuilder, clusterNodeUsingGossipSeedSettingsBuilder);
    }

    public static EventStoreBuilder newBuilder() {
        return new EventStoreBuilder(Settings.newBuilder(), null, null, null, null);
    }

    public EventStoreBuilder singleNodeAddress(InetSocketAddress address) {
        if (this.singleNodeSettingsBuilder == null) {
            this.singleNodeSettingsBuilder = SingleNodeSettings.newBuilder();
        }
        this.singleNodeSettingsBuilder = this.singleNodeSettingsBuilder.address(address);
        this.clusterNodeUsingDnsSettingsBuilder = null;
        this.clusterNodeUsingGossipSeedSettingsBuilder = null;
        return this;
    }

    public EventStoreBuilder singleNodeAddress(String host, int port) {
        if (this.singleNodeSettingsBuilder == null) {
            this.singleNodeSettingsBuilder = SingleNodeSettings.newBuilder();
        }
        this.singleNodeSettingsBuilder = this.singleNodeSettingsBuilder.address(host, port);
        this.clusterNodeUsingDnsSettingsBuilder = null;
        this.clusterNodeUsingGossipSeedSettingsBuilder = null;
        return this;
    }

    public EventStoreBuilder clusterNodeUsingDns(Function<ClusterNodeSettings.BuilderForDnsDiscoverer, ClusterNodeSettings.BuilderForDnsDiscoverer> modifier) {
        Preconditions.checkNotNull(modifier, "modifier is null");
        this.clusterNodeUsingDnsSettingsBuilder = modifier.apply(this.clusterNodeUsingDnsSettingsBuilder == null ? ClusterNodeSettings.forDnsDiscoverer() : this.clusterNodeUsingDnsSettingsBuilder);
        this.clusterNodeUsingGossipSeedSettingsBuilder = null;
        this.singleNodeSettingsBuilder = null;
        return this;
    }

    public EventStoreBuilder clusterNodeUsingGossipSeeds(Function<ClusterNodeSettings.BuilderForGossipSeedDiscoverer, ClusterNodeSettings.BuilderForGossipSeedDiscoverer> modifier) {
        Preconditions.checkNotNull(modifier, "modifier is null");
        this.clusterNodeUsingGossipSeedSettingsBuilder = modifier.apply(this.clusterNodeUsingGossipSeedSettingsBuilder == null ? ClusterNodeSettings.forGossipSeedDiscoverer() : this.clusterNodeUsingGossipSeedSettingsBuilder);
        this.clusterNodeUsingDnsSettingsBuilder = null;
        this.singleNodeSettingsBuilder = null;
        return this;
    }

    public EventStoreBuilder tcpSettings(Function<TcpSettings.Builder, TcpSettings.Builder> modifier) {
        Preconditions.checkNotNull(modifier, "modifier is null");
        this.tcpSettingsBuilder = modifier.apply(this.tcpSettingsBuilder == null ? TcpSettings.newBuilder() : this.tcpSettingsBuilder);
        return this;
    }

    public EventStoreBuilder useSslConnection(String certificateCommonName) {
        this.settingsBuilder.sslSettings(SslSettings.trustCertificateCN(certificateCommonName));
        return this;
    }

    public EventStoreBuilder useSslConnection(File certificateFile) {
        this.settingsBuilder.sslSettings(SslSettings.trustCertificate(certificateFile));
        return this;
    }

    public EventStoreBuilder useSslConnection() {
        this.settingsBuilder.sslSettings(SslSettings.trustAllCertificates());
        return this;
    }

    public EventStoreBuilder noSslConnection() {
        this.settingsBuilder.sslSettings(SslSettings.noSsl());
        return this;
    }

    public EventStoreBuilder connectionName(String connectionName) {
        this.settingsBuilder.connectionName(connectionName);
        return this;
    }

    public EventStoreBuilder endpointDiscovererFactory(EndpointDiscovererFactory endpointDiscovererFactory) {
        this.settingsBuilder.endpointDiscovererFactory(endpointDiscovererFactory);
        return this;
    }

    public EventStoreBuilder endpointDiscoverer(EndpointDiscoverer endpointDiscoverer) {
        this.settingsBuilder.endpointDiscoverer(endpointDiscoverer);
        return this;
    }

    public EventStoreBuilder reconnectionDelay(Duration duration) {
        this.settingsBuilder.reconnectionDelay(duration);
        return this;
    }

    public EventStoreBuilder maxReconnections(int count) {
        this.settingsBuilder.maxReconnections(count);
        return this;
    }

    public EventStoreBuilder heartbeatInterval(Duration duration) {
        this.settingsBuilder.heartbeatInterval(duration);
        return this;
    }

    public EventStoreBuilder heartbeatTimeout(Duration duration) {
        this.settingsBuilder.heartbeatTimeout(duration);
        return this;
    }

    public EventStoreBuilder requireMaster(boolean requireMaster) {
        this.settingsBuilder.requireMaster(requireMaster);
        return this;
    }

    public EventStoreBuilder userCredentials(UserCredentials userCredentials) {
        this.settingsBuilder.userCredentials(userCredentials);
        return this;
    }

    public EventStoreBuilder userCredentials(String username, String password) {
        this.settingsBuilder.userCredentials(username, password);
        return this;
    }

    public EventStoreBuilder noUserCredentials() {
        this.settingsBuilder.noUserCredentials();
        return this;
    }

    public EventStoreBuilder operationTimeout(Duration duration) {
        this.settingsBuilder.operationTimeout(duration);
        return this;
    }

    public EventStoreBuilder operationTimeoutCheckInterval(Duration duration) {
        this.settingsBuilder.operationTimeoutCheckInterval(duration);
        return this;
    }

    public EventStoreBuilder maxOperationQueueSize(int size) {
        this.settingsBuilder.maxOperationQueueSize(size);
        return this;
    }

    public EventStoreBuilder maxConcurrentOperations(int count) {
        this.settingsBuilder.maxConcurrentOperations(count);
        return this;
    }

    public EventStoreBuilder maxOperationRetries(int count) {
        this.settingsBuilder.maxOperationRetries(count);
        return this;
    }

    public EventStoreBuilder persistentSubscriptionBufferSize(int size) {
        this.settingsBuilder.persistentSubscriptionBufferSize(size);
        return this;
    }

    public EventStoreBuilder persistentSubscriptionAutoAck(boolean persistentSubscriptionAutoAck) {
        this.settingsBuilder.persistentSubscriptionAutoAck(persistentSubscriptionAutoAck);
        return this;
    }

    public EventStoreBuilder failOnNoServerResponse(boolean failOnNoServerResponse) {
        this.settingsBuilder.failOnNoServerResponse(failOnNoServerResponse);
        return this;
    }

    public EventStoreBuilder disconnectOnTcpChannelError(boolean disconnectOnTcpChannelError) {
        this.settingsBuilder.disconnectOnTcpChannelError(disconnectOnTcpChannelError);
        return this;
    }

    public EventStoreBuilder executor(Executor executor) {
        this.settingsBuilder.executor(executor);
        return this;
    }

    public EventStoreBuilder defaultExecutor() {
        this.settingsBuilder.defaultExecutor();
        return this;
    }

    public EventStore build() {
        if (this.singleNodeSettingsBuilder != null) {
            this.settingsBuilder.nodeSettings(this.singleNodeSettingsBuilder.build());
        }
        if (this.clusterNodeUsingDnsSettingsBuilder != null) {
            this.settingsBuilder.nodeSettings(this.clusterNodeUsingDnsSettingsBuilder.build());
        }
        if (this.clusterNodeUsingGossipSeedSettingsBuilder != null) {
            this.settingsBuilder.nodeSettings(this.clusterNodeUsingGossipSeedSettingsBuilder.build());
        }
        if (this.tcpSettingsBuilder != null) {
            this.settingsBuilder.tcpSettings(this.tcpSettingsBuilder.build());
        }
        return new EventStoreTcp(this.settingsBuilder.build());
    }
}

