/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc;

import com.github.msemys.esjc.system.SystemConsumerStrategy;
import com.github.msemys.esjc.util.Numbers;
import com.github.msemys.esjc.util.Preconditions;
import java.time.Duration;

public class PersistentSubscriptionSettings {
    public static final PersistentSubscriptionSettings DEFAULT = PersistentSubscriptionSettings.newBuilder().build();
    public final boolean resolveLinkTos;
    public final long startFrom;
    public final boolean timingStatistics;
    public final Duration messageTimeout;
    public final int readBatchSize;
    public final int maxRetryCount;
    public final int liveBufferSize;
    public final int historyBufferSize;
    public final Duration checkPointAfter;
    public final int minCheckPointCount;
    public final int maxCheckPointCount;
    public final int maxSubscriberCount;
    public final SystemConsumerStrategy namedConsumerStrategy;

    private PersistentSubscriptionSettings(Builder builder) {
        this.resolveLinkTos = builder.resolveLinkTos;
        this.startFrom = builder.startFrom;
        this.timingStatistics = builder.timingStatistics;
        this.messageTimeout = builder.messageTimeout;
        this.readBatchSize = builder.readBatchSize;
        this.maxRetryCount = builder.maxRetryCount;
        this.liveBufferSize = builder.liveBufferSize;
        this.historyBufferSize = builder.historyBufferSize;
        this.checkPointAfter = builder.checkPointAfter;
        this.minCheckPointCount = builder.minCheckPointCount;
        this.maxCheckPointCount = builder.maxCheckPointCount;
        this.maxSubscriberCount = builder.maxSubscriberCount;
        this.namedConsumerStrategy = builder.namedConsumerStrategy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PersistentSubscriptionSettings{");
        sb.append("resolveLinkTos=").append(this.resolveLinkTos);
        sb.append(", startFrom=").append(this.startFrom);
        sb.append(", timingStatistics=").append(this.timingStatistics);
        sb.append(", messageTimeout=").append(this.messageTimeout);
        sb.append(", readBatchSize=").append(this.readBatchSize);
        sb.append(", maxRetryCount=").append(this.maxRetryCount);
        sb.append(", liveBufferSize=").append(this.liveBufferSize);
        sb.append(", historyBufferSize=").append(this.historyBufferSize);
        sb.append(", checkPointAfter=").append(this.checkPointAfter);
        sb.append(", minCheckPointCount=").append(this.minCheckPointCount);
        sb.append(", maxCheckPointCount=").append(this.maxCheckPointCount);
        sb.append(", maxSubscriberCount=").append(this.maxSubscriberCount);
        sb.append(", namedConsumerStrategy='").append((Object)this.namedConsumerStrategy).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Boolean resolveLinkTos;
        private Long startFrom;
        private Boolean timingStatistics;
        private Duration messageTimeout;
        private Integer readBatchSize;
        private Integer maxRetryCount;
        private Integer liveBufferSize;
        private Integer historyBufferSize;
        private Duration checkPointAfter;
        private Integer minCheckPointCount;
        private Integer maxCheckPointCount;
        private Integer maxSubscriberCount;
        private SystemConsumerStrategy namedConsumerStrategy;

        public Builder resolveLinkTos(boolean resolveLinkTos) {
            this.resolveLinkTos = resolveLinkTos;
            return this;
        }

        public Builder startFromBeginning() {
            return this.startFrom(0L);
        }

        public Builder startFromCurrent() {
            return this.startFrom(-1L);
        }

        public Builder startFrom(long startFrom) {
            this.startFrom = startFrom;
            return this;
        }

        public Builder timingStatistics(boolean timingStatistics) {
            this.timingStatistics = timingStatistics;
            return this;
        }

        public Builder messageTimeout(Duration messageTimeout) {
            this.messageTimeout = messageTimeout;
            return this;
        }

        public Builder readBatchSize(int readBatchSize) {
            this.readBatchSize = readBatchSize;
            return this;
        }

        public Builder maxRetryCount(int maxRetryCount) {
            this.maxRetryCount = maxRetryCount;
            return this;
        }

        public Builder liveBufferSize(int liveBufferSize) {
            this.liveBufferSize = liveBufferSize;
            return this;
        }

        public Builder historyBufferSize(int historyBufferSize) {
            this.historyBufferSize = historyBufferSize;
            return this;
        }

        public Builder checkPointAfter(Duration checkPointAfter) {
            this.checkPointAfter = checkPointAfter;
            return this;
        }

        public Builder minCheckPointCount(int minCheckPointCount) {
            this.minCheckPointCount = minCheckPointCount;
            return this;
        }

        public Builder maxCheckPointCount(int maxCheckPointCount) {
            this.maxCheckPointCount = maxCheckPointCount;
            return this;
        }

        public Builder maxSubscriberCount(int maxSubscriberCount) {
            this.maxSubscriberCount = maxSubscriberCount;
            return this;
        }

        public Builder namedConsumerStrategy(SystemConsumerStrategy namedConsumerStrategy) {
            this.namedConsumerStrategy = namedConsumerStrategy;
            return this;
        }

        public PersistentSubscriptionSettings build() {
            if (this.resolveLinkTos == null) {
                this.resolveLinkTos = false;
            }
            if (this.startFrom == null) {
                this.startFrom = -1L;
            } else {
                Preconditions.checkArgument(this.startFrom >= -1L, "startFrom should be >= -1");
            }
            if (this.timingStatistics == null) {
                this.timingStatistics = false;
            }
            if (this.messageTimeout == null) {
                this.messageTimeout = Duration.ofSeconds(30L);
            }
            if (this.readBatchSize == null) {
                this.readBatchSize = 20;
            } else {
                Preconditions.checkArgument(Numbers.isPositive(this.readBatchSize), "readBatchSize should be positive");
            }
            if (this.maxRetryCount == null) {
                this.maxRetryCount = 10;
            } else {
                Preconditions.checkArgument(Numbers.isPositive(this.maxRetryCount), "maxRetryCount should be positive");
            }
            if (this.liveBufferSize == null) {
                this.liveBufferSize = 500;
            } else {
                Preconditions.checkArgument(Numbers.isPositive(this.liveBufferSize), "liveBufferSize should be positive");
            }
            if (this.historyBufferSize == null) {
                this.historyBufferSize = 500;
            } else {
                Preconditions.checkArgument(Numbers.isPositive(this.historyBufferSize), "historyBufferSize should be positive");
            }
            if (this.checkPointAfter == null) {
                this.checkPointAfter = Duration.ofSeconds(2L);
            }
            if (this.minCheckPointCount == null) {
                this.minCheckPointCount = 10;
            } else {
                Preconditions.checkArgument(Numbers.isPositive(this.minCheckPointCount), "minCheckPointCount should be positive");
            }
            if (this.maxCheckPointCount == null) {
                this.maxCheckPointCount = 1000;
            } else {
                Preconditions.checkArgument(Numbers.isPositive(this.maxCheckPointCount), "maxCheckPointCount should be positive");
            }
            if (this.maxSubscriberCount == null) {
                this.maxSubscriberCount = 0;
            } else {
                Preconditions.checkArgument(!Numbers.isNegative(this.maxSubscriberCount), "maxSubscriberCount should not be negative");
            }
            if (this.namedConsumerStrategy == null) {
                this.namedConsumerStrategy = SystemConsumerStrategy.ROUND_ROBIN;
            }
            return new PersistentSubscriptionSettings(this);
        }
    }
}

