/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc;

import com.github.msemys.esjc.util.Preconditions;

public class Position
implements Comparable<Position> {
    public static final Position START = new Position(0L, 0L);
    public static final Position END = new Position(-1L, -1L);
    public final long commitPosition;
    public final long preparePosition;

    public Position(long commitPosition, long preparePosition) {
        Preconditions.checkArgument(commitPosition >= preparePosition, "The commit position cannot be less than the prepare position");
        this.commitPosition = commitPosition;
        this.preparePosition = preparePosition;
    }

    @Override
    public int compareTo(Position that) {
        if (this.commitPosition < that.commitPosition || this.commitPosition == that.commitPosition && this.preparePosition < that.preparePosition) {
            return -1;
        }
        if (this.commitPosition > that.commitPosition || this.commitPosition == that.commitPosition && this.preparePosition > that.preparePosition) {
            return 1;
        }
        if (this.commitPosition == that.commitPosition && this.preparePosition == that.preparePosition) {
            return 0;
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Position position = (Position)o;
        if (this.commitPosition != position.commitPosition) {
            return false;
        }
        return this.preparePosition == position.preparePosition;
    }

    public int hashCode() {
        int result = (int)(this.commitPosition ^ this.commitPosition >>> 32);
        result = 31 * result + (int)(this.preparePosition ^ this.preparePosition >>> 32);
        return result;
    }

    public String toString() {
        return String.format("%d/%d", this.commitPosition, this.preparePosition);
    }

    public static Position of(long commitPosition, long preparePosition) {
        return new Position(commitPosition, preparePosition);
    }
}

