/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc;

import com.github.msemys.esjc.proto.EventStoreClientMessages;
import com.github.msemys.esjc.util.EmptyArrays;
import com.github.msemys.esjc.util.UUIDConverter;
import java.time.Instant;
import java.util.UUID;

public class RecordedEvent {
    public final String eventStreamId;
    public final UUID eventId;
    public final long eventNumber;
    public final String eventType;
    public final byte[] data;
    public final byte[] metadata;
    public final boolean isJson;
    public final Instant created;

    public RecordedEvent(EventStoreClientMessages.EventRecord eventRecord) {
        this.eventStreamId = eventRecord.getEventStreamId();
        this.eventId = UUIDConverter.toUUID(eventRecord.getEventId().toByteArray());
        this.eventNumber = eventRecord.getEventNumber();
        this.eventType = eventRecord.getEventType();
        this.data = eventRecord.hasData() ? eventRecord.getData().toByteArray() : EmptyArrays.EMPTY_BYTES;
        this.metadata = eventRecord.hasMetadata() ? eventRecord.getMetadata().toByteArray() : EmptyArrays.EMPTY_BYTES;
        this.isJson = eventRecord.getDataContentType() == 1;
        this.created = eventRecord.hasCreatedEpoch() ? Instant.ofEpochMilli(eventRecord.getCreatedEpoch()) : null;
    }
}

