/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc;

import com.github.msemys.esjc.UserCredentials;
import com.github.msemys.esjc.node.DefaultEndpointDiscovererFactory;
import com.github.msemys.esjc.node.DelegatedEndpointDiscovererFactory;
import com.github.msemys.esjc.node.EndpointDiscoverer;
import com.github.msemys.esjc.node.EndpointDiscovererFactory;
import com.github.msemys.esjc.node.cluster.ClusterNodeSettings;
import com.github.msemys.esjc.node.single.SingleNodeSettings;
import com.github.msemys.esjc.ssl.SslSettings;
import com.github.msemys.esjc.tcp.TcpSettings;
import com.github.msemys.esjc.util.Numbers;
import com.github.msemys.esjc.util.Preconditions;
import com.github.msemys.esjc.util.Ranges;
import com.github.msemys.esjc.util.Strings;
import com.github.msemys.esjc.util.concurrent.DefaultThreadFactory;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class Settings {
    public final String connectionName;
    public final TcpSettings tcpSettings;
    public final SingleNodeSettings singleNodeSettings;
    public final ClusterNodeSettings clusterNodeSettings;
    public final SslSettings sslSettings;
    public final EndpointDiscovererFactory endpointDiscovererFactory;
    public final Duration reconnectionDelay;
    public final Duration heartbeatInterval;
    public final Duration heartbeatTimeout;
    public final boolean requireMaster;
    public final UserCredentials userCredentials;
    public final Duration operationTimeout;
    public final Duration operationTimeoutCheckInterval;
    public final int maxOperationQueueSize;
    public final int maxConcurrentOperations;
    public final int maxOperationRetries;
    public final int maxReconnections;
    public final int persistentSubscriptionBufferSize;
    public final boolean persistentSubscriptionAutoAck;
    public final boolean failOnNoServerResponse;
    public final boolean disconnectOnTcpChannelError;
    public final Executor executor;

    private Settings(Builder builder) {
        this.connectionName = builder.connectionName;
        this.tcpSettings = builder.tcpSettings;
        this.singleNodeSettings = builder.singleNodeSettings;
        this.clusterNodeSettings = builder.clusterNodeSettings;
        this.sslSettings = builder.sslSettings;
        this.endpointDiscovererFactory = builder.endpointDiscovererFactory;
        this.reconnectionDelay = builder.reconnectionDelay;
        this.heartbeatInterval = builder.heartbeatInterval;
        this.heartbeatTimeout = builder.heartbeatTimeout;
        this.requireMaster = builder.requireMaster;
        this.userCredentials = builder.userCredentials;
        this.operationTimeout = builder.operationTimeout;
        this.operationTimeoutCheckInterval = builder.operationTimeoutCheckInterval;
        this.maxOperationQueueSize = builder.maxOperationQueueSize;
        this.maxConcurrentOperations = builder.maxConcurrentOperations;
        this.maxOperationRetries = builder.maxOperationRetries;
        this.maxReconnections = builder.maxReconnections;
        this.persistentSubscriptionBufferSize = builder.persistentSubscriptionBufferSize;
        this.persistentSubscriptionAutoAck = builder.persistentSubscriptionAutoAck;
        this.failOnNoServerResponse = builder.failOnNoServerResponse;
        this.disconnectOnTcpChannelError = builder.disconnectOnTcpChannelError;
        this.executor = builder.executor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Settings{");
        sb.append("connectionName='").append(this.connectionName).append('\'');
        sb.append(", tcpSettings=").append(this.tcpSettings);
        sb.append(", singleNodeSettings=").append(this.singleNodeSettings);
        sb.append(", clusterNodeSettings=").append(this.clusterNodeSettings);
        sb.append(", sslSettings=").append(this.sslSettings);
        sb.append(", endpointDiscovererFactory=").append(this.endpointDiscovererFactory);
        sb.append(", reconnectionDelay=").append(this.reconnectionDelay);
        sb.append(", heartbeatInterval=").append(this.heartbeatInterval);
        sb.append(", heartbeatTimeout=").append(this.heartbeatTimeout);
        sb.append(", requireMaster=").append(this.requireMaster);
        sb.append(", userCredentials=").append(this.userCredentials);
        sb.append(", operationTimeout=").append(this.operationTimeout);
        sb.append(", operationTimeoutCheckInterval=").append(this.operationTimeoutCheckInterval);
        sb.append(", maxOperationQueueSize=").append(this.maxOperationQueueSize);
        sb.append(", maxConcurrentOperations=").append(this.maxConcurrentOperations);
        sb.append(", maxOperationRetries=").append(this.maxOperationRetries);
        sb.append(", maxReconnections=").append(this.maxReconnections);
        sb.append(", persistentSubscriptionBufferSize=").append(this.persistentSubscriptionBufferSize);
        sb.append(", persistentSubscriptionAutoAck=").append(this.persistentSubscriptionAutoAck);
        sb.append(", failOnNoServerResponse=").append(this.failOnNoServerResponse);
        sb.append(", disconnectOnTcpChannelError=").append(this.disconnectOnTcpChannelError);
        sb.append(", executor=").append(this.executor);
        sb.append('}');
        return sb.toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String connectionName;
        private TcpSettings tcpSettings;
        private SingleNodeSettings singleNodeSettings;
        private ClusterNodeSettings clusterNodeSettings;
        private SslSettings sslSettings;
        private EndpointDiscovererFactory endpointDiscovererFactory;
        private Duration reconnectionDelay;
        private Duration heartbeatInterval;
        private Duration heartbeatTimeout;
        private Boolean requireMaster;
        private UserCredentials userCredentials;
        private Duration operationTimeout;
        private Duration operationTimeoutCheckInterval;
        private Integer maxOperationQueueSize;
        private Integer maxConcurrentOperations;
        private Integer maxOperationRetries;
        private Integer maxReconnections;
        private Integer persistentSubscriptionBufferSize;
        private Boolean persistentSubscriptionAutoAck;
        private Boolean failOnNoServerResponse;
        private Boolean disconnectOnTcpChannelError;
        private Executor executor;

        private Builder() {
        }

        public Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public Builder tcpSettings(TcpSettings tcpSettings) {
            this.tcpSettings = tcpSettings;
            return this;
        }

        public Builder nodeSettings(SingleNodeSettings singleNodeSettings) {
            this.singleNodeSettings = singleNodeSettings;
            return this;
        }

        public Builder nodeSettings(ClusterNodeSettings clusterNodeSettings) {
            this.clusterNodeSettings = clusterNodeSettings;
            return this;
        }

        public Builder sslSettings(SslSettings sslSettings) {
            this.sslSettings = sslSettings;
            return this;
        }

        public Builder endpointDiscovererFactory(EndpointDiscovererFactory endpointDiscovererFactory) {
            this.endpointDiscovererFactory = endpointDiscovererFactory;
            return this;
        }

        public Builder endpointDiscoverer(EndpointDiscoverer endpointDiscoverer) {
            return this.endpointDiscovererFactory(new DelegatedEndpointDiscovererFactory(endpointDiscoverer));
        }

        public Builder reconnectionDelay(Duration duration) {
            this.reconnectionDelay = duration;
            return this;
        }

        public Builder heartbeatInterval(Duration heartbeatInterval) {
            this.heartbeatInterval = heartbeatInterval;
            return this;
        }

        public Builder heartbeatTimeout(Duration heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        public Builder requireMaster(boolean requireMaster) {
            this.requireMaster = requireMaster;
            return this;
        }

        public Builder userCredentials(UserCredentials userCredentials) {
            this.userCredentials = userCredentials;
            return this;
        }

        public Builder userCredentials(String username, String password) {
            return this.userCredentials(new UserCredentials(username, password));
        }

        public Builder noUserCredentials() {
            return this.userCredentials(null);
        }

        public Builder operationTimeout(Duration operationTimeout) {
            this.operationTimeout = operationTimeout;
            return this;
        }

        public Builder operationTimeoutCheckInterval(Duration operationTimeoutCheckInterval) {
            this.operationTimeoutCheckInterval = operationTimeoutCheckInterval;
            return this;
        }

        public Builder maxOperationQueueSize(int maxOperationQueueSize) {
            this.maxOperationQueueSize = maxOperationQueueSize;
            return this;
        }

        public Builder maxConcurrentOperations(int maxConcurrentOperations) {
            this.maxConcurrentOperations = maxConcurrentOperations;
            return this;
        }

        public Builder maxOperationRetries(int maxOperationRetries) {
            this.maxOperationRetries = maxOperationRetries;
            return this;
        }

        public Builder maxReconnections(int maxReconnections) {
            this.maxReconnections = maxReconnections;
            return this;
        }

        public Builder persistentSubscriptionBufferSize(int persistentSubscriptionBufferSize) {
            this.persistentSubscriptionBufferSize = persistentSubscriptionBufferSize;
            return this;
        }

        public Builder persistentSubscriptionAutoAck(boolean persistentSubscriptionAutoAck) {
            this.persistentSubscriptionAutoAck = persistentSubscriptionAutoAck;
            return this;
        }

        public Builder failOnNoServerResponse(boolean failOnNoServerResponse) {
            this.failOnNoServerResponse = failOnNoServerResponse;
            return this;
        }

        public Builder disconnectOnTcpChannelError(boolean disconnectOnTcpChannelError) {
            this.disconnectOnTcpChannelError = disconnectOnTcpChannelError;
            return this;
        }

        public Builder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder defaultExecutor() {
            return this.executor(null);
        }

        public Settings build() {
            if (this.endpointDiscovererFactory == null) {
                Preconditions.checkArgument(this.singleNodeSettings != null || this.clusterNodeSettings != null, "Missing node settings");
                Preconditions.checkArgument(this.singleNodeSettings == null || this.clusterNodeSettings == null, "Usage of 'single-node' and 'cluster-node' settings at once is not allowed");
                this.endpointDiscovererFactory = new DefaultEndpointDiscovererFactory();
            }
            if (Strings.isNullOrEmpty(this.connectionName)) {
                this.connectionName = "ESJC-" + UUID.randomUUID().toString();
            }
            if (this.tcpSettings == null) {
                this.tcpSettings = TcpSettings.newBuilder().build();
            }
            if (this.sslSettings == null) {
                this.sslSettings = SslSettings.noSsl();
            }
            if (this.reconnectionDelay == null) {
                this.reconnectionDelay = Duration.ofSeconds(1L);
            }
            if (this.heartbeatInterval == null) {
                this.heartbeatInterval = Duration.ofMillis(500L);
            }
            if (this.heartbeatTimeout == null) {
                this.heartbeatTimeout = Duration.ofMillis(1500L);
            }
            if (this.requireMaster == null) {
                this.requireMaster = true;
            }
            if (this.operationTimeout == null) {
                this.operationTimeout = Duration.ofSeconds(7L);
            }
            if (this.operationTimeoutCheckInterval == null) {
                this.operationTimeoutCheckInterval = Duration.ofSeconds(1L);
            }
            if (this.maxOperationQueueSize == null) {
                this.maxOperationQueueSize = 5000;
            } else {
                Preconditions.checkArgument(Numbers.isPositive(this.maxOperationQueueSize), "maxOperationQueueSize should be positive");
            }
            if (this.maxConcurrentOperations == null) {
                this.maxConcurrentOperations = 5000;
            } else {
                Preconditions.checkArgument(Numbers.isPositive(this.maxConcurrentOperations), "maxConcurrentOperations should be positive");
            }
            if (this.maxOperationRetries == null) {
                this.maxOperationRetries = 10;
            } else {
                Preconditions.checkArgument(Ranges.ATTEMPTS_RANGE.contains(this.maxOperationRetries), "maxOperationRetries value is out of range. Allowed range: %s.", Ranges.ATTEMPTS_RANGE.toString());
            }
            if (this.maxReconnections == null) {
                this.maxReconnections = 10;
            } else {
                Preconditions.checkArgument(Ranges.ATTEMPTS_RANGE.contains(this.maxReconnections), "maxReconnections value is out of range. Allowed range: %s.", Ranges.ATTEMPTS_RANGE.toString());
            }
            if (this.persistentSubscriptionBufferSize == null) {
                this.persistentSubscriptionBufferSize = 10;
            } else {
                Preconditions.checkArgument(Numbers.isPositive(this.persistentSubscriptionBufferSize), "persistentSubscriptionBufferSize should be positive");
            }
            if (this.persistentSubscriptionAutoAck == null) {
                this.persistentSubscriptionAutoAck = true;
            }
            if (this.failOnNoServerResponse == null) {
                this.failOnNoServerResponse = false;
            }
            if (this.disconnectOnTcpChannelError == null) {
                this.disconnectOnTcpChannelError = false;
            }
            if (this.executor == null) {
                this.executor = new ThreadPoolExecutor(2, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DefaultThreadFactory("es"));
            }
            return new Settings(this);
        }
    }
}

