/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class StreamAcl {
    public final List<String> readRoles;
    public final List<String> writeRoles;
    public final List<String> deleteRoles;
    public final List<String> metaReadRoles;
    public final List<String> metaWriteRoles;

    private StreamAcl(Builder builder) {
        this.readRoles = builder.readRoles;
        this.writeRoles = builder.writeRoles;
        this.deleteRoles = builder.deleteRoles;
        this.metaReadRoles = builder.metaReadRoles;
        this.metaWriteRoles = builder.metaWriteRoles;
    }

    public String toString() {
        return String.format("Read: %s, Write: %s, Delete: %s, MetaRead: %s, MetaWrite: %s", this.readRoles == null ? "<null>" : "[" + this.readRoles.stream().collect(Collectors.joining(",")) + "]", this.writeRoles == null ? "<null>" : "[" + this.writeRoles.stream().collect(Collectors.joining(",")) + "]", this.deleteRoles == null ? "<null>" : "[" + this.deleteRoles.stream().collect(Collectors.joining(",")) + "]", this.metaReadRoles == null ? "<null>" : "[" + this.metaReadRoles.stream().collect(Collectors.joining(",")) + "]", this.metaWriteRoles == null ? "<null>" : "[" + this.metaWriteRoles.stream().collect(Collectors.joining(",")) + "]");
    }

    public Builder toBuilder() {
        return StreamAcl.newBuilder().readRoles(this.readRoles).writeRoles(this.writeRoles).deleteRoles(this.deleteRoles).metaReadRoles(this.metaReadRoles).metaWriteRoles(this.metaWriteRoles);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private List<String> readRoles;
        private List<String> writeRoles;
        private List<String> deleteRoles;
        private List<String> metaReadRoles;
        private List<String> metaWriteRoles;

        private Builder() {
        }

        public Builder readRoles(List<String> readRoles) {
            this.readRoles = readRoles;
            return this;
        }

        public Builder writeRoles(List<String> writeRoles) {
            this.writeRoles = writeRoles;
            return this;
        }

        public Builder deleteRoles(List<String> deleteRoles) {
            this.deleteRoles = deleteRoles;
            return this;
        }

        public Builder metaReadRoles(List<String> metaReadRoles) {
            this.metaReadRoles = metaReadRoles;
            return this;
        }

        public Builder metaWriteRoles(List<String> metaWriteRoles) {
            this.metaWriteRoles = metaWriteRoles;
            return this;
        }

        public StreamAcl build() {
            this.readRoles = this.readRoles != null ? Collections.unmodifiableList(this.readRoles) : null;
            this.writeRoles = this.writeRoles != null ? Collections.unmodifiableList(this.writeRoles) : null;
            this.deleteRoles = this.deleteRoles != null ? Collections.unmodifiableList(this.deleteRoles) : null;
            this.metaReadRoles = this.metaReadRoles != null ? Collections.unmodifiableList(this.metaReadRoles) : null;
            this.metaWriteRoles = this.metaWriteRoles != null ? Collections.unmodifiableList(this.metaWriteRoles) : null;
            return new StreamAcl(this);
        }
    }
}

