/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc;

import com.github.msemys.esjc.StreamAcl;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StreamAclJsonAdapter
extends TypeAdapter<StreamAcl> {
    private static final String ACL_READ = "$r";
    private static final String ACL_WRITE = "$w";
    private static final String ACL_DELETE = "$d";
    private static final String ACL_META_READ = "$mr";
    private static final String ACL_META_WRITE = "$mw";

    public void write(JsonWriter writer, StreamAcl value) throws IOException {
        writer.beginObject();
        StreamAclJsonAdapter.writeRoles(writer, ACL_READ, value.readRoles);
        StreamAclJsonAdapter.writeRoles(writer, ACL_WRITE, value.writeRoles);
        StreamAclJsonAdapter.writeRoles(writer, ACL_DELETE, value.deleteRoles);
        StreamAclJsonAdapter.writeRoles(writer, ACL_META_READ, value.metaReadRoles);
        StreamAclJsonAdapter.writeRoles(writer, ACL_META_WRITE, value.metaWriteRoles);
        writer.endObject();
    }

    public StreamAcl read(JsonReader reader) throws IOException {
        StreamAcl.Builder builder = StreamAcl.newBuilder();
        reader.beginObject();
        while (reader.peek() != JsonToken.END_OBJECT && reader.hasNext()) {
            String name;
            switch (name = reader.nextName()) {
                case "$r": {
                    builder.readRoles(StreamAclJsonAdapter.readRoles(reader));
                    break;
                }
                case "$w": {
                    builder.writeRoles(StreamAclJsonAdapter.readRoles(reader));
                    break;
                }
                case "$d": {
                    builder.deleteRoles(StreamAclJsonAdapter.readRoles(reader));
                    break;
                }
                case "$mr": {
                    builder.metaReadRoles(StreamAclJsonAdapter.readRoles(reader));
                    break;
                }
                case "$mw": {
                    builder.metaWriteRoles(StreamAclJsonAdapter.readRoles(reader));
                }
            }
        }
        reader.endObject();
        return builder.build();
    }

    private static void writeRoles(JsonWriter writer, String name, List<String> roles) throws IOException {
        if (roles != null) {
            writer.name(name);
            if (roles.size() == 1) {
                writer.value(roles.get(0));
            } else {
                writer.beginArray();
                for (String role : roles) {
                    writer.value(role);
                }
                writer.endArray();
            }
        }
    }

    private static List<String> readRoles(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.STRING) {
            return Collections.singletonList(reader.nextString());
        }
        ArrayList<String> roles = new ArrayList<String>();
        reader.beginArray();
        while (reader.peek() != JsonToken.END_ARRAY) {
            roles.add(reader.nextString());
        }
        reader.endArray();
        return roles;
    }
}

