/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc;

import com.github.msemys.esjc.AbstractEventsIterator;
import com.github.msemys.esjc.ResolvedEvent;
import com.github.msemys.esjc.StreamEventsSlice;
import com.github.msemys.esjc.operation.StreamDeletedException;
import com.github.msemys.esjc.operation.StreamNotFoundException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class StreamEventsIterator
extends AbstractEventsIterator<Long, StreamEventsSlice> {
    StreamEventsIterator(long eventNumber, Function<Long, CompletableFuture<StreamEventsSlice>> reader) {
        super(eventNumber, reader);
    }

    @Override
    protected void onBatchReceived(StreamEventsSlice slice) {
        switch (slice.status) {
            case Success: {
                super.onBatchReceived(slice);
                break;
            }
            case StreamNotFound: {
                throw new StreamNotFoundException(slice.stream);
            }
            case StreamDeleted: {
                throw new StreamDeletedException(slice.stream);
            }
            default: {
                throw new IllegalStateException(String.format("Unexpected read status: %s", new Object[]{slice.status}));
            }
        }
    }

    @Override
    protected Long getNextCursor(StreamEventsSlice slice) {
        return slice.nextEventNumber;
    }

    @Override
    protected List<ResolvedEvent> getEvents(StreamEventsSlice slice) {
        return slice.events;
    }

    @Override
    protected boolean isEndOfStream(StreamEventsSlice slice) {
        return slice.isEndOfStream;
    }
}

