/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc;

import com.github.msemys.esjc.ReadDirection;
import com.github.msemys.esjc.ResolvedEvent;
import com.github.msemys.esjc.SliceReadStatus;
import com.github.msemys.esjc.proto.EventStoreClientMessages;
import com.github.msemys.esjc.util.Preconditions;
import com.github.msemys.esjc.util.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class StreamEventsSlice {
    public final SliceReadStatus status;
    public final String stream;
    public final long fromEventNumber;
    public final ReadDirection readDirection;
    public final List<ResolvedEvent> events;
    public final long nextEventNumber;
    public final long lastEventNumber;
    public final boolean isEndOfStream;

    public StreamEventsSlice(SliceReadStatus status, String stream, long fromEventNumber, ReadDirection readDirection, List<EventStoreClientMessages.ResolvedIndexedEvent> events, long nextEventNumber, long lastEventNumber, boolean isEndOfStream) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(stream), "stream is null or empty");
        this.status = status;
        this.stream = stream;
        this.fromEventNumber = fromEventNumber;
        this.readDirection = readDirection;
        this.events = events == null ? Collections.emptyList() : (List)events.stream().map(ResolvedEvent::new).collect(Collectors.toCollection(() -> new ArrayList(events.size())));
        this.nextEventNumber = nextEventNumber;
        this.lastEventNumber = lastEventNumber;
        this.isEndOfStream = isEndOfStream;
    }
}

