/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc;

import com.github.msemys.esjc.StreamAcl;
import com.github.msemys.esjc.StreamMetadataJsonAdapter;
import com.github.msemys.esjc.util.Numbers;
import com.github.msemys.esjc.util.Preconditions;
import com.github.msemys.esjc.util.Strings;
import com.github.msemys.esjc.util.Throwables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;

public class StreamMetadata {
    private static final StreamMetadata EMPTY = StreamMetadata.newBuilder().build();
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(StreamMetadata.class, (Object)new StreamMetadataJsonAdapter()).serializeNulls().create();
    public final Long maxCount;
    public final Duration maxAge;
    public final Long truncateBefore;
    public final Duration cacheControl;
    public final StreamAcl acl;
    public final List<Property> customProperties;

    private StreamMetadata(Builder builder) {
        this.maxCount = builder.maxCount;
        this.maxAge = builder.maxAge;
        this.truncateBefore = builder.truncateBefore;
        this.cacheControl = builder.cacheControl;
        this.acl = builder.aclBuilder != null ? builder.aclBuilder.build() : null;
        this.customProperties = builder.customProperties != null ? Collections.unmodifiableList(builder.customProperties) : Collections.emptyList();
    }

    public Optional<Property> findCustomProperty(String name) {
        return this.customProperties.stream().filter(p -> p.name.equals(name)).findFirst();
    }

    public Property getCustomProperty(String name) throws NoSuchElementException {
        return this.findCustomProperty(name).get();
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        if (this.maxCount != null) {
            builder.maxCount(this.maxCount);
        }
        if (this.maxAge != null) {
            builder.maxAge(this.maxAge);
        }
        if (this.truncateBefore != null) {
            builder.truncateBefore(this.truncateBefore);
        }
        if (this.cacheControl != null) {
            builder.cacheControl(this.cacheControl);
        }
        if (this.acl != null) {
            builder.aclBuilder = this.acl.toBuilder();
        }
        if (this.customProperties != null) {
            builder.customProperties(new ArrayList<Property>(this.customProperties));
        }
        return builder;
    }

    public String toJson() {
        return gson.toJson((Object)this);
    }

    public static StreamMetadata fromJson(String json) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(json), "json is null or empty");
        return StreamMetadata.fromJson(Strings.toBytes(json));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StreamMetadata fromJson(byte[] bytes) {
        Preconditions.checkNotNull(bytes, "bytes is null");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes)));){
            StreamMetadata streamMetadata = (StreamMetadata)gson.fromJson(new JsonReader((Reader)reader), StreamMetadata.class);
            return streamMetadata;
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    public static StreamMetadata empty() {
        return EMPTY;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Property {
        public final String name;
        public final Object value;

        private Property(String name, Object value) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
            this.name = name;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Property property = (Property)o;
            if (this.name != null ? !this.name.equals(property.name) : property.name != null) {
                return false;
            }
            return this.value != null ? this.value.equals(property.value) : property.value == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            if (this.value instanceof String) {
                return (String)this.value;
            }
            return this.value != null ? this.value.toString() : null;
        }

        public Integer toInteger() {
            if (this.value instanceof Number) {
                return ((Number)this.value).intValue();
            }
            return this.value != null ? Integer.valueOf(Integer.parseInt(this.toString())) : null;
        }

        public Long toLong() {
            if (this.value instanceof Number) {
                return ((Number)this.value).longValue();
            }
            return this.value != null ? Long.valueOf(Long.parseLong(this.toString())) : null;
        }

        public Double toDouble() {
            if (this.value instanceof Number) {
                return ((Number)this.value).doubleValue();
            }
            return this.value != null ? Double.valueOf(Double.parseDouble(this.toString())) : null;
        }

        public Boolean toBoolean() {
            if (this.value instanceof Boolean) {
                return (Boolean)this.value;
            }
            return this.value != null ? Boolean.valueOf(Boolean.parseBoolean(this.toString())) : null;
        }

        public String[] toStrings() {
            String[] stringArray;
            if (this.value instanceof String[]) {
                return (String[])this.value;
            }
            if (this.value != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.toString();
            } else {
                stringArray = null;
            }
            return stringArray;
        }

        public Integer[] toIntegers() {
            Integer[] integerArray;
            if (this.value instanceof Number[]) {
                return (Integer[])Arrays.stream((Number[])this.value).map(v -> v != null ? Integer.valueOf(v.intValue()) : null).toArray(Integer[]::new);
            }
            if (this.value instanceof String[]) {
                return new Integer[((String[])this.value).length];
            }
            if (this.value != null) {
                Integer[] integerArray2 = new Integer[1];
                integerArray = integerArray2;
                integerArray2[0] = Integer.parseInt(this.toString());
            } else {
                integerArray = null;
            }
            return integerArray;
        }

        public Long[] toLongs() {
            Long[] longArray;
            if (this.value instanceof Number[]) {
                return (Long[])Arrays.stream((Number[])this.value).map(v -> v != null ? Long.valueOf(v.longValue()) : null).toArray(Long[]::new);
            }
            if (this.value instanceof String[]) {
                return new Long[((String[])this.value).length];
            }
            if (this.value != null) {
                Long[] longArray2 = new Long[1];
                longArray = longArray2;
                longArray2[0] = Long.parseLong(this.toString());
            } else {
                longArray = null;
            }
            return longArray;
        }

        public Double[] toDoubles() {
            Double[] doubleArray;
            if (this.value instanceof Number[]) {
                return (Double[])Arrays.stream((Number[])this.value).map(v -> v != null ? Double.valueOf(v.doubleValue()) : null).toArray(Double[]::new);
            }
            if (this.value instanceof String[]) {
                return new Double[((String[])this.value).length];
            }
            if (this.value != null) {
                Double[] doubleArray2 = new Double[1];
                doubleArray = doubleArray2;
                doubleArray2[0] = Double.parseDouble(this.toString());
            } else {
                doubleArray = null;
            }
            return doubleArray;
        }

        public Boolean[] toBooleans() {
            Boolean[] booleanArray;
            if (this.value instanceof Boolean[]) {
                return (Boolean[])this.value;
            }
            if (this.value instanceof String[]) {
                return new Boolean[((String[])this.value).length];
            }
            if (this.value != null) {
                Boolean[] booleanArray2 = new Boolean[1];
                booleanArray = booleanArray2;
                booleanArray2[0] = Boolean.parseBoolean(this.toString());
            } else {
                booleanArray = null;
            }
            return booleanArray;
        }
    }

    public static class Builder {
        private Long maxCount;
        private Duration maxAge;
        private Long truncateBefore;
        private Duration cacheControl;
        private StreamAcl.Builder aclBuilder;
        private List<Property> customProperties = new ArrayList<Property>();

        private Builder() {
        }

        public Builder maxCount(Long maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        public Builder maxAge(Duration maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public Builder truncateBefore(Long truncateBefore) {
            this.truncateBefore = truncateBefore;
            return this;
        }

        public Builder cacheControl(Duration cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public Builder acl(StreamAcl acl) {
            this.aclBuilder = acl != null ? acl.toBuilder() : null;
            return this;
        }

        public Builder aclReadRoles(List<String> aclReadRoles) {
            this.aclBuilder().readRoles(aclReadRoles);
            return this;
        }

        public Builder aclWriteRoles(List<String> aclWriteRoles) {
            this.aclBuilder().writeRoles(aclWriteRoles);
            return this;
        }

        public Builder aclDeleteRoles(List<String> aclDeleteRoles) {
            this.aclBuilder().deleteRoles(aclDeleteRoles);
            return this;
        }

        public Builder aclMetaReadRoles(List<String> aclMetaReadRoles) {
            this.aclBuilder().metaReadRoles(aclMetaReadRoles);
            return this;
        }

        public Builder aclMetaWriteRoles(List<String> aclMetaWriteRoles) {
            this.aclBuilder().metaWriteRoles(aclMetaWriteRoles);
            return this;
        }

        private StreamAcl.Builder aclBuilder() {
            if (this.aclBuilder == null) {
                this.aclBuilder = StreamAcl.newBuilder();
            }
            return this.aclBuilder;
        }

        public Builder customProperties(List<Property> properties) {
            this.customProperties = properties;
            return this;
        }

        public Builder customProperty(Property property) {
            int index = this.customProperties.stream().filter(p -> p.name.equals(property.name)).findFirst().map(p -> this.customProperties.indexOf(p)).orElse(-1);
            if (index > -1) {
                this.customProperties.set(index, property);
            } else {
                this.customProperties.add(property);
            }
            return this;
        }

        public Builder customProperty(String name, String value) {
            return this.customProperty(new Property(name, value));
        }

        public Builder customProperty(String name, Number value) {
            return this.customProperty(new Property(name, value));
        }

        public Builder customProperty(String name, Boolean value) {
            return this.customProperty(new Property(name, value));
        }

        public Builder customProperty(String name, String ... values) {
            return this.customProperty(new Property(name, values));
        }

        public Builder customProperty(String name, Number ... values) {
            return this.customProperty(new Property(name, values));
        }

        public Builder customProperty(String name, Boolean ... values) {
            return this.customProperty(new Property(name, values));
        }

        public StreamMetadata build() {
            if (this.maxCount != null) {
                Preconditions.checkArgument(Numbers.isPositive(this.maxCount), "maxCount should be positive");
            }
            if (this.maxAge != null) {
                Preconditions.checkArgument(!Duration.ZERO.equals(this.maxAge), "maxAge cannot be zero");
            }
            if (this.truncateBefore != null) {
                Preconditions.checkArgument(!Numbers.isNegative(this.truncateBefore), "truncateBefore should not be negative");
            }
            if (this.cacheControl != null) {
                Preconditions.checkArgument(!Duration.ZERO.equals(this.cacheControl), "cacheControl cannot be zero");
            }
            return new StreamMetadata(this);
        }
    }
}

