/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc;

import com.github.msemys.esjc.StreamAcl;
import com.github.msemys.esjc.StreamAclJsonAdapter;
import com.github.msemys.esjc.StreamMetadata;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;

public class StreamMetadataJsonAdapter
extends TypeAdapter<StreamMetadata> {
    private static final String MAX_AGE = "$maxAge";
    private static final String MAX_COUNT = "$maxCount";
    private static final String TRUNCATE_BEFORE = "$tb";
    private static final String CACHE_CONTROL = "$cacheControl";
    private static final String ACL = "$acl";
    private final StreamAclJsonAdapter streamAclJsonAdapter = new StreamAclJsonAdapter();

    public void write(JsonWriter writer, StreamMetadata value) throws IOException {
        writer.beginObject();
        if (value.maxCount != null) {
            writer.name(MAX_COUNT).value((Number)value.maxCount);
        }
        if (value.maxAge != null) {
            writer.name(MAX_AGE).value(value.maxAge.getSeconds());
        }
        if (value.truncateBefore != null) {
            writer.name(TRUNCATE_BEFORE).value((Number)value.truncateBefore);
        }
        if (value.cacheControl != null) {
            writer.name(CACHE_CONTROL).value(value.cacheControl.getSeconds());
        }
        if (value.acl != null) {
            writer.name(ACL);
            this.streamAclJsonAdapter.write(writer, value.acl);
        }
        if (value.customProperties != null) {
            for (StreamMetadata.Property property : value.customProperties) {
                JsonWriter propertyWriter = writer.name(property.name);
                if (property.value == null) {
                    propertyWriter.nullValue();
                    continue;
                }
                if (property.value instanceof Number) {
                    propertyWriter.value((Number)property.value);
                    continue;
                }
                if (property.value instanceof Boolean) {
                    propertyWriter.value((Boolean)property.value);
                    continue;
                }
                if (property.value instanceof String[]) {
                    propertyWriter.beginArray();
                    for (String string : (String[])property.value) {
                        propertyWriter.value(string);
                    }
                    propertyWriter.endArray();
                    continue;
                }
                if (property.value instanceof Number[]) {
                    propertyWriter.beginArray();
                    for (Number number : (Number[])property.value) {
                        propertyWriter.value(number);
                    }
                    propertyWriter.endArray();
                    continue;
                }
                if (property.value instanceof Boolean[]) {
                    propertyWriter.beginArray();
                    for (Boolean bl : (Boolean[])property.value) {
                        propertyWriter.value(bl);
                    }
                    propertyWriter.endArray();
                    continue;
                }
                propertyWriter.value(property.value.toString());
            }
        }
        writer.endObject();
    }

    public StreamMetadata read(JsonReader reader) throws IOException {
        StreamMetadata.Builder builder = StreamMetadata.newBuilder();
        if (reader.peek() == JsonToken.NULL) {
            return null;
        }
        reader.beginObject();
        block27: while (reader.peek() != JsonToken.END_OBJECT && reader.hasNext()) {
            String name;
            switch (name = reader.nextName()) {
                case "$maxCount": {
                    builder.maxCount(reader.nextLong());
                    continue block27;
                }
                case "$maxAge": {
                    builder.maxAge(Duration.ofSeconds(reader.nextLong()));
                    continue block27;
                }
                case "$tb": {
                    builder.truncateBefore(reader.nextLong());
                    continue block27;
                }
                case "$cacheControl": {
                    builder.cacheControl(Duration.ofSeconds(reader.nextLong()));
                    continue block27;
                }
                case "$acl": {
                    StreamAcl acl = this.streamAclJsonAdapter.read(reader);
                    if (acl == null) continue block27;
                    builder.aclReadRoles(acl.readRoles);
                    builder.aclWriteRoles(acl.writeRoles);
                    builder.aclDeleteRoles(acl.deleteRoles);
                    builder.aclMetaReadRoles(acl.metaReadRoles);
                    builder.aclMetaWriteRoles(acl.metaWriteRoles);
                    continue block27;
                }
            }
            switch (reader.peek()) {
                case NULL: {
                    reader.nextNull();
                    builder.customProperty(name, (String)null);
                    continue block27;
                }
                case BEGIN_ARRAY: {
                    ArrayList<Object> values = new ArrayList<Object>();
                    reader.beginArray();
                    while (reader.peek() != JsonToken.END_ARRAY) {
                        switch (reader.peek()) {
                            case NULL: {
                                reader.nextNull();
                                values.add(null);
                                break;
                            }
                            case BOOLEAN: {
                                values.add(reader.nextBoolean());
                                break;
                            }
                            case NUMBER: {
                                values.add(new BigDecimal(reader.nextString()));
                                break;
                            }
                            case STRING: {
                                values.add(reader.nextString());
                            }
                        }
                    }
                    reader.endArray();
                    if (values.stream().anyMatch(v -> v instanceof Boolean)) {
                        builder.customProperty(name, (Boolean[])values.stream().toArray(Boolean[]::new));
                        continue block27;
                    }
                    if (values.stream().anyMatch(v -> v instanceof Number)) {
                        builder.customProperty(name, (Number[])values.stream().toArray(Number[]::new));
                        continue block27;
                    }
                    builder.customProperty(name, (String[])values.stream().toArray(String[]::new));
                    continue block27;
                }
                case BOOLEAN: {
                    builder.customProperty(name, (Boolean)reader.nextBoolean());
                    continue block27;
                }
                case NUMBER: {
                    builder.customProperty(name, (Number)new BigDecimal(reader.nextString()));
                    continue block27;
                }
                case STRING: {
                    builder.customProperty(name, reader.nextString());
                    continue block27;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        return builder.build();
    }
}

