/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc;

import com.github.msemys.esjc.StreamAcl;
import com.github.msemys.esjc.SystemSettingsJsonAdapter;
import com.github.msemys.esjc.util.Preconditions;
import com.github.msemys.esjc.util.Strings;
import com.github.msemys.esjc.util.Throwables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

public class SystemSettings {
    private static final SystemSettings EMPTY = SystemSettings.newBuilder().build();
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(SystemSettings.class, (Object)new SystemSettingsJsonAdapter()).create();
    public final StreamAcl userStreamAcl;
    public final StreamAcl systemStreamAcl;

    private SystemSettings(Builder builder) {
        this.userStreamAcl = builder.userStreamAcl;
        this.systemStreamAcl = builder.systemStreamAcl;
    }

    public String toJson() {
        return gson.toJson((Object)this);
    }

    public static SystemSettings fromJson(String json) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(json), "json is null or empty");
        return SystemSettings.fromJson(Strings.toBytes(json));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SystemSettings fromJson(byte[] bytes) {
        Preconditions.checkNotNull(bytes, "bytes is null");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes)));){
            SystemSettings systemSettings = (SystemSettings)gson.fromJson(new JsonReader((Reader)reader), SystemSettings.class);
            return systemSettings;
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    public String toString() {
        return String.format("UserStreamAcl: (%s), SystemStreamAcl: (%s)", this.userStreamAcl, this.systemStreamAcl);
    }

    public static SystemSettings empty() {
        return EMPTY;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private StreamAcl userStreamAcl;
        private StreamAcl systemStreamAcl;

        private Builder() {
        }

        public Builder userStreamAcl(StreamAcl userStreamAcl) {
            this.userStreamAcl = userStreamAcl;
            return this;
        }

        public Builder systemStreamAcl(StreamAcl systemStreamAcl) {
            this.systemStreamAcl = systemStreamAcl;
            return this;
        }

        public SystemSettings build() {
            return new SystemSettings(this);
        }
    }
}

