/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc;

import com.github.msemys.esjc.EventData;
import com.github.msemys.esjc.UserCredentials;
import com.github.msemys.esjc.WriteResult;
import com.github.msemys.esjc.transaction.TransactionManager;
import com.github.msemys.esjc.util.Numbers;
import com.github.msemys.esjc.util.Preconditions;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;

public class Transaction
implements AutoCloseable {
    public final long transactionId;
    private final UserCredentials userCredentials;
    private final TransactionManager transactionManager;
    private boolean isRolledBack;
    private boolean isCommitted;

    public Transaction(long transactionId, UserCredentials userCredentials, TransactionManager transactionManager) {
        Preconditions.checkArgument(!Numbers.isNegative(transactionId), "transactionId should not be negative");
        this.transactionId = transactionId;
        this.userCredentials = userCredentials;
        this.transactionManager = transactionManager;
    }

    public CompletableFuture<WriteResult> commit() {
        Preconditions.checkState(!this.isRolledBack, "Cannot commit a rolled-back transaction");
        Preconditions.checkState(!this.isCommitted, "Transaction is already committed");
        this.isCommitted = true;
        return this.transactionManager.commit(this, this.userCredentials);
    }

    public CompletableFuture<Void> write(EventData event) {
        return this.write(Collections.singletonList(event));
    }

    public CompletableFuture<Void> write(Iterable<EventData> events) {
        Preconditions.checkState(!this.isRolledBack, "Cannot write to a rolled-back transaction");
        Preconditions.checkState(!this.isCommitted, "Transaction is already committed");
        return this.transactionManager.write(this, events);
    }

    public void rollback() {
        Preconditions.checkState(!this.isCommitted, "Transaction is already committed");
        this.isRolledBack = true;
    }

    @Override
    public void close() {
        if (!this.isCommitted) {
            this.isRolledBack = true;
        }
    }
}

