/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.event;

import com.github.msemys.esjc.EventStoreListener;
import com.github.msemys.esjc.event.Event;
import com.github.msemys.esjc.util.Preconditions;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventQueue {
    private static final Logger logger = LoggerFactory.getLogger(EventQueue.class);
    private final Executor executor;
    private final Queue<Event> queue = new ConcurrentLinkedQueue<Event>();
    private final Set<EventStoreListener> listeners = new CopyOnWriteArraySet<EventStoreListener>();
    private final AtomicBoolean processing = new AtomicBoolean();

    public EventQueue(Executor executor) {
        this.executor = executor;
    }

    public void register(EventStoreListener listener) {
        this.listeners.add(listener);
    }

    public void unregister(EventStoreListener listener) {
        this.listeners.remove(listener);
    }

    public void enqueue(Event event) {
        Preconditions.checkNotNull(event, "event is null");
        this.queue.offer(event);
        if (this.processing.compareAndSet(false, true)) {
            this.executor.execute(this::process);
        }
    }

    private void process() {
        block2: while (true) {
            Event event;
            if ((event = this.queue.poll()) != null) {
                Iterator<EventStoreListener> iterator = this.listeners.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block2;
                    EventStoreListener listener = iterator.next();
                    try {
                        listener.onEvent(event);
                    }
                    catch (Exception e) {
                        logger.error("Error occurred while handling '{}' event in {}", new Object[]{event.getClass().getSimpleName(), listener.getClass().getName(), e});
                    }
                }
            }
            this.processing.set(false);
            if (this.queue.isEmpty() || !this.processing.compareAndSet(false, true)) break;
        }
    }
}

