/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.http;

import com.github.msemys.esjc.UserCredentials;
import com.github.msemys.esjc.http.HttpClientException;
import com.github.msemys.esjc.http.HttpOperationTimeoutException;
import com.github.msemys.esjc.http.handler.HttpResponseHandler;
import com.github.msemys.esjc.util.Numbers;
import com.github.msemys.esjc.util.Preconditions;
import com.github.msemys.esjc.util.Strings;
import com.github.msemys.esjc.util.concurrent.ResettableLatch;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class HttpClient
implements AutoCloseable {
    private final EventLoopGroup group = new NioEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory("es-http"));
    private final Bootstrap bootstrap;
    private final String host;
    private final boolean acceptGzip;
    private final long operationTimeoutMillis;
    private final ExecutorService queueExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory("es-http-queue"));
    private final Queue<HttpOperation> queue = new ConcurrentLinkedQueue<HttpOperation>();
    private final AtomicBoolean isProcessing = new AtomicBoolean();
    private final ResettableLatch received = new ResettableLatch(false);
    private volatile Channel channel;

    private HttpClient(final Builder builder) {
        this.host = builder.address.getHostString();
        this.acceptGzip = builder.acceptGzip;
        this.operationTimeoutMillis = builder.operationTimeout.toMillis();
        this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().remoteAddress((SocketAddress)builder.address).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_REUSEADDR, (Object)false)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)builder.connectTimeout.toMillis()))).group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("http-codec", (ChannelHandler)new HttpClientCodec());
                if (HttpClient.this.acceptGzip) {
                    pipeline.addLast("content-decompressor", (ChannelHandler)new HttpContentDecompressor());
                }
                pipeline.addLast("object-aggregator", (ChannelHandler)new HttpObjectAggregator(builder.maxContentLength.intValue()));
                pipeline.addLast("logger", (ChannelHandler)new LoggingHandler(HttpClient.class, LogLevel.TRACE));
                pipeline.addLast("response-handler", (ChannelHandler)new HttpResponseHandler());
            }
        });
    }

    public CompletableFuture<FullHttpResponse> send(HttpRequest request) {
        Preconditions.checkNotNull(request, "request is null");
        Preconditions.checkState(this.isRunning(), "HTTP client is closed");
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)this.host);
        if (this.acceptGzip) {
            request.headers().set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.GZIP);
        }
        CompletableFuture<FullHttpResponse> response = new CompletableFuture<FullHttpResponse>();
        this.enqueue(new HttpOperation(request, response));
        return response;
    }

    private void enqueue(HttpOperation operation) {
        Preconditions.checkNotNull(operation, "operation is null");
        this.queue.offer(operation);
        if (this.isProcessing.compareAndSet(false, true)) {
            this.queueExecutor.execute(this::processQueue);
        }
    }

    private void processQueue() {
        while (true) {
            block6: {
                HttpOperation operation;
                if ((operation = this.queue.poll()) != null) {
                    if (this.channel == null || !this.channel.isActive()) {
                        try {
                            this.channel = this.bootstrap.connect().syncUninterruptibly().channel();
                        }
                        catch (Exception e) {
                            operation.response.completeExceptionally(e);
                            if (this.isRunning()) {
                                continue;
                            }
                            break block6;
                        }
                    }
                    this.write(operation);
                    continue;
                }
            }
            this.isProcessing.set(false);
            if (!this.isRunning() || this.queue.isEmpty() || !this.isProcessing.compareAndSet(false, true)) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(HttpOperation operation) {
        this.received.reset();
        operation.response.whenComplete((r, t) -> this.received.release());
        HttpResponseHandler responseHandler = (HttpResponseHandler)this.channel.pipeline().get(HttpResponseHandler.class);
        try {
            responseHandler.pendingResponse = operation.response;
            this.channel.writeAndFlush((Object)operation.request).sync();
            if (!this.received.await(this.operationTimeoutMillis, TimeUnit.MILLISECONDS)) {
                this.channel.close().awaitUninterruptibly();
                operation.response.completeExceptionally(new HttpOperationTimeoutException(operation.request));
            }
        }
        catch (Exception e) {
            operation.response.completeExceptionally(e);
        }
        finally {
            responseHandler.pendingResponse = null;
        }
    }

    private boolean isRunning() {
        return !this.group.isShuttingDown();
    }

    @Override
    public void close() {
        HttpOperation operation;
        Future shutdownFuture = this.group.shutdownGracefully(0L, 15L, TimeUnit.SECONDS);
        this.queueExecutor.shutdown();
        while ((operation = this.queue.poll()) != null) {
            operation.response.completeExceptionally(new HttpClientException("Client closed"));
        }
        shutdownFuture.awaitUninterruptibly();
        try {
            this.queueExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void addAuthorizationHeader(FullHttpRequest request, UserCredentials userCredentials) {
        Preconditions.checkNotNull(request, "request is null");
        Preconditions.checkNotNull(userCredentials, "userCredentials is null");
        byte[] encodedCredentials = Base64.getEncoder().encode(Strings.toBytes(userCredentials.username + ":" + userCredentials.password));
        request.headers().add((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)("Basic " + Strings.newString(encodedCredentials)));
    }

    public static FullHttpRequest newRequest(HttpMethod method, String uri, UserCredentials userCredentials) {
        Preconditions.checkNotNull(method, "method is null");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(uri), "uri is null or empty");
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, uri);
        if (userCredentials != null) {
            HttpClient.addAuthorizationHeader((FullHttpRequest)request, userCredentials);
        }
        return request;
    }

    public static FullHttpRequest newRequest(HttpMethod method, String uri, String body, CharSequence contentType, UserCredentials userCredentials) {
        Preconditions.checkNotNull(method, "method is null");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(uri), "uri is null or empty");
        Preconditions.checkNotNull(body, "body is null");
        Preconditions.checkNotNull(contentType, "contentType is null");
        Preconditions.checkArgument(contentType.length() > 0, "contentType is empty");
        ByteBuf data = Unpooled.copiedBuffer((CharSequence)body, (Charset)StandardCharsets.UTF_8);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, uri, data);
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)data.readableBytes());
        if (userCredentials != null) {
            HttpClient.addAuthorizationHeader((FullHttpRequest)request, userCredentials);
        }
        return request;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static class HttpOperation {
        final HttpRequest request;
        final CompletableFuture<FullHttpResponse> response;

        HttpOperation(HttpRequest request, CompletableFuture<FullHttpResponse> response) {
            Preconditions.checkNotNull(request, "request is null");
            Preconditions.checkNotNull(response, "response is null");
            this.request = request;
            this.response = response;
        }
    }

    public static class Builder {
        private InetSocketAddress address;
        private Duration connectTimeout;
        private Duration operationTimeout;
        private Boolean acceptGzip;
        private Integer maxContentLength;

        public Builder address(String host, int port) {
            return this.address(new InetSocketAddress(host, port));
        }

        public Builder address(InetSocketAddress address) {
            this.address = address;
            return this;
        }

        public Builder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder operationTimeout(Duration operationTimeout) {
            this.operationTimeout = operationTimeout;
            return this;
        }

        public Builder acceptGzip(boolean acceptGzip) {
            this.acceptGzip = acceptGzip;
            return this;
        }

        public Builder maxContentLength(int maxContentLength) {
            this.maxContentLength = maxContentLength;
            return this;
        }

        public HttpClient build() {
            Preconditions.checkNotNull(this.address, "address is null");
            if (this.connectTimeout == null) {
                this.connectTimeout = Duration.ofSeconds(10L);
            }
            if (this.operationTimeout == null) {
                this.operationTimeout = Duration.ofSeconds(7L);
            }
            if (this.acceptGzip == null) {
                this.acceptGzip = false;
            }
            if (this.maxContentLength == null) {
                this.maxContentLength = 0x8000000;
            } else {
                Preconditions.checkArgument(Numbers.isPositive(this.maxContentLength), "maxContentLength should be positive");
            }
            return new HttpClient(this);
        }
    }
}

