/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.http.handler;

import com.github.msemys.esjc.http.HttpClientException;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseHandler
extends SimpleChannelInboundHandler<FullHttpResponse> {
    private static final Logger logger = LoggerFactory.getLogger(HttpResponseHandler.class);
    public volatile CompletableFuture<FullHttpResponse> pendingResponse;

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) throws Exception {
        if (this.pendingResponse != null) {
            this.pendingResponse.complete(msg);
        } else {
            logger.warn("Unexpected HTTP response received: {}", (Object)msg);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.pendingResponse != null) {
            this.pendingResponse.completeExceptionally(cause);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.pendingResponse != null) {
            this.pendingResponse.completeExceptionally(new HttpClientException("Connection closed"));
        }
        ctx.fireChannelInactive();
    }
}

