/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.node;

import com.github.msemys.esjc.Settings;
import com.github.msemys.esjc.node.EndpointDiscoverer;
import com.github.msemys.esjc.node.EndpointDiscovererFactory;
import com.github.msemys.esjc.node.cluster.ClusterEndpointDiscoverer;
import com.github.msemys.esjc.node.single.SingleEndpointDiscoverer;
import com.github.msemys.esjc.util.Preconditions;
import java.util.concurrent.ScheduledExecutorService;

public class DefaultEndpointDiscovererFactory
implements EndpointDiscovererFactory {
    @Override
    public EndpointDiscoverer create(Settings settings, ScheduledExecutorService scheduler) {
        Preconditions.checkNotNull(settings, "settings is null");
        Preconditions.checkNotNull(scheduler, "scheduler is null");
        if (settings.singleNodeSettings != null) {
            return new SingleEndpointDiscoverer(settings.singleNodeSettings, settings.sslSettings.useSslConnection);
        }
        if (settings.clusterNodeSettings != null) {
            return new ClusterEndpointDiscoverer(settings.clusterNodeSettings, scheduler);
        }
        throw new IllegalStateException("Node settings not found");
    }
}

