/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.node.cluster;

import com.github.msemys.esjc.node.cluster.GossipSeed;
import com.github.msemys.esjc.node.cluster.NodePreference;
import com.github.msemys.esjc.util.Numbers;
import com.github.msemys.esjc.util.Preconditions;
import com.github.msemys.esjc.util.Ranges;
import com.github.msemys.esjc.util.Strings;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ClusterNodeSettings {
    public final String dns;
    public final int maxDiscoverAttempts;
    public final Duration discoverAttemptInterval;
    public final int externalGossipPort;
    public final List<GossipSeed> gossipSeeds;
    public final Duration gossipTimeout;
    public final NodePreference nodePreference;

    private ClusterNodeSettings(Builder builder) {
        this.dns = builder.dns;
        this.maxDiscoverAttempts = builder.maxDiscoverAttempts;
        this.discoverAttemptInterval = builder.discoverAttemptInterval;
        this.externalGossipPort = builder.externalGossipPort;
        this.gossipSeeds = builder.gossipSeeds;
        this.gossipTimeout = builder.gossipTimeout;
        this.nodePreference = builder.nodePreference;
    }

    public static BuilderForGossipSeedDiscoverer forGossipSeedDiscoverer() {
        return new BuilderForGossipSeedDiscoverer();
    }

    public static BuilderForDnsDiscoverer forDnsDiscoverer() {
        return new BuilderForDnsDiscoverer();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClusterNodeSettings{");
        sb.append("dns='").append(this.dns).append('\'');
        sb.append(", maxDiscoverAttempts=").append(this.maxDiscoverAttempts);
        sb.append(", discoverAttemptInterval=").append(this.discoverAttemptInterval);
        sb.append(", externalGossipPort=").append(this.externalGossipPort);
        sb.append(", gossipSeeds=").append(this.gossipSeeds);
        sb.append(", gossipTimeout=").append(this.gossipTimeout);
        sb.append(", nodePreference=").append((Object)this.nodePreference);
        sb.append('}');
        return sb.toString();
    }

    private static class Builder {
        private String dns;
        private Integer maxDiscoverAttempts;
        private Duration discoverAttemptInterval;
        private Integer externalGossipPort;
        private List<GossipSeed> gossipSeeds;
        private Duration gossipTimeout;
        private NodePreference nodePreference;

        private Builder() {
        }

        public ClusterNodeSettings build() {
            if (this.dns == null) {
                this.dns = "";
            }
            if (this.maxDiscoverAttempts == null) {
                this.maxDiscoverAttempts = 10;
            } else {
                Preconditions.checkArgument(Ranges.ATTEMPTS_RANGE.contains(this.maxDiscoverAttempts), "maxDiscoverAttempts value is out of range. Allowed range: %s.", Ranges.ATTEMPTS_RANGE.toString());
            }
            if (this.discoverAttemptInterval == null) {
                this.discoverAttemptInterval = Duration.ofMillis(500L);
            }
            if (this.externalGossipPort == null) {
                this.externalGossipPort = 0;
            } else {
                Preconditions.checkArgument(Numbers.isPositive(this.externalGossipPort), "externalGossipPort should be positive");
            }
            this.gossipSeeds = this.gossipSeeds == null ? Collections.emptyList() : Collections.unmodifiableList(this.gossipSeeds);
            if (this.gossipTimeout == null) {
                this.gossipTimeout = Duration.ofSeconds(1L);
            }
            if (this.nodePreference == null) {
                this.nodePreference = NodePreference.Master;
            }
            return new ClusterNodeSettings(this);
        }
    }

    public static class BuilderForDnsDiscoverer
    extends Builder {
        public BuilderForDnsDiscoverer dns(String dns) {
            ((Builder)this).dns = dns;
            return this;
        }

        public BuilderForDnsDiscoverer maxDiscoverAttempts(int maxDiscoverAttempts) {
            ((Builder)this).maxDiscoverAttempts = maxDiscoverAttempts;
            return this;
        }

        public BuilderForDnsDiscoverer discoverAttemptInterval(Duration discoverAttemptInterval) {
            ((Builder)this).discoverAttemptInterval = discoverAttemptInterval;
            return this;
        }

        public BuilderForDnsDiscoverer externalGossipPort(int externalGossipPort) {
            ((Builder)this).externalGossipPort = externalGossipPort;
            return this;
        }

        public BuilderForDnsDiscoverer gossipTimeout(Duration gossipTimeout) {
            ((Builder)this).gossipTimeout = gossipTimeout;
            return this;
        }

        public BuilderForDnsDiscoverer nodePreference(NodePreference nodePreference) {
            ((Builder)this).nodePreference = nodePreference;
            return this;
        }

        @Override
        public ClusterNodeSettings build() {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(((Builder)this).dns), "dns is null or empty");
            if (((Builder)this).externalGossipPort == null) {
                ((Builder)this).externalGossipPort = 30778;
            }
            return super.build();
        }
    }

    public static class BuilderForGossipSeedDiscoverer
    extends Builder {
        public BuilderForGossipSeedDiscoverer maxDiscoverAttempts(int maxDiscoverAttempts) {
            ((Builder)this).maxDiscoverAttempts = maxDiscoverAttempts;
            return this;
        }

        public BuilderForGossipSeedDiscoverer discoverAttemptInterval(Duration discoverAttemptInterval) {
            ((Builder)this).discoverAttemptInterval = discoverAttemptInterval;
            return this;
        }

        public BuilderForGossipSeedDiscoverer gossipSeedEndpoints(List<InetSocketAddress> endpoints) {
            return this.gossipSeeds(endpoints.stream().map(GossipSeed::new).collect(Collectors.toList()));
        }

        public BuilderForGossipSeedDiscoverer gossipSeeds(List<GossipSeed> gossipSeeds) {
            ((Builder)this).gossipSeeds = gossipSeeds;
            return this;
        }

        public BuilderForGossipSeedDiscoverer gossipTimeout(Duration gossipTimeout) {
            ((Builder)this).gossipTimeout = gossipTimeout;
            return this;
        }

        public BuilderForGossipSeedDiscoverer nodePreference(NodePreference nodePreference) {
            ((Builder)this).nodePreference = nodePreference;
            return this;
        }

        @Override
        public ClusterNodeSettings build() {
            Preconditions.checkArgument(((Builder)this).gossipSeeds != null && !((Builder)this).gossipSeeds.isEmpty(), "Gossip seeds are not specified.");
            return super.build();
        }
    }
}

