/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.node.cluster;

import com.github.msemys.esjc.node.cluster.VNodeState;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.UUID;

public class MemberInfoDto {
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.systemDefault());
    public UUID instanceId;
    public Instant timeStamp;
    public VNodeState state;
    public boolean isAlive;
    public String internalTcpIp;
    public int internalTcpPort;
    public int internalSecureTcpPort;
    public String externalTcpIp;
    public int externalTcpPort;
    public int externalSecureTcpPort;
    public String internalHttpIp;
    public int internalHttpPort;
    public String externalHttpIp;
    public int externalHttpPort;
    public long lastCommitPosition;
    public long writerCheckpoint;
    public long chaserCheckpoint;
    public long epochPosition;
    public long epochNumber;
    public UUID epochId;
    public int nodePriority;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.state == VNodeState.Manager) {
            sb.append("MAN ").append(this.instanceId.toString()).append(" <").append(this.isAlive ? "LIVE" : "DEAD").append("> ").append("[").append((Object)this.state).append(", ").append(this.internalHttpIp).append(":").append(this.internalHttpPort).append(", ").append(this.externalHttpIp).append(":").append(this.externalHttpPort).append("] | ").append(TIMESTAMP_FORMATTER.format(this.timeStamp));
        } else {
            sb.append("VND ").append(this.instanceId.toString()).append(" <").append(this.isAlive ? "LIVE" : "DEAD").append("> ").append("[").append((Object)this.state).append(", ").append(this.internalTcpIp).append(":").append(this.internalTcpPort).append(", ").append(this.internalSecureTcpPort > 0 ? this.internalTcpIp + ":" + this.internalSecureTcpPort : "n/a").append(", ").append(this.externalTcpIp).append(":").append(this.externalTcpPort).append(", ").append(this.externalSecureTcpPort > 0 ? this.externalTcpIp + ":" + this.externalSecureTcpPort : "n/a").append(", ").append(this.internalHttpIp).append(":").append(this.internalHttpPort).append(", ").append(this.externalHttpIp).append(":").append(this.externalHttpPort).append("] ").append(this.lastCommitPosition).append("/").append(this.writerCheckpoint).append("/").append(this.chaserCheckpoint).append("E").append(this.epochNumber).append("@").append(this.epochPosition).append(":").append(this.epochId.toString()).append(" | ").append(TIMESTAMP_FORMATTER.format(this.timeStamp));
        }
        return sb.toString();
    }
}

