/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.node.single;

import com.github.msemys.esjc.node.EndpointDiscoverer;
import com.github.msemys.esjc.node.NodeEndpoints;
import com.github.msemys.esjc.node.single.SingleNodeSettings;
import com.github.msemys.esjc.util.Preconditions;
import io.netty.util.NetUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleEndpointDiscoverer
implements EndpointDiscoverer {
    private static final Logger logger = LoggerFactory.getLogger(SingleEndpointDiscoverer.class);
    private final String hostname;
    private final InetAddress ipAddress;
    private final int port;
    private final boolean ssl;

    public SingleEndpointDiscoverer(SingleNodeSettings settings, boolean ssl) {
        Preconditions.checkNotNull(settings, "settings is null");
        this.hostname = settings.address.getHostString();
        this.ipAddress = SingleEndpointDiscoverer.maybeIpAddress(this.hostname);
        this.port = settings.address.getPort();
        this.ssl = ssl;
    }

    @Override
    public CompletableFuture<NodeEndpoints> discover(InetSocketAddress failedTcpEndpoint) {
        InetSocketAddress address = this.ipAddress != null ? new InetSocketAddress(this.ipAddress, this.port) : new InetSocketAddress(this.hostname, this.port);
        return CompletableFuture.completedFuture(new NodeEndpoints(this.ssl ? null : address, this.ssl ? address : null));
    }

    private static InetAddress maybeIpAddress(String address) {
        if (address == null) {
            return null;
        }
        byte[] ipAddressBytes = NetUtil.createByteArrayFromIpAddressString((String)address);
        if (ipAddressBytes != null) {
            try {
                return InetAddress.getByAddress(ipAddressBytes);
            }
            catch (UnknownHostException e) {
                logger.warn("Unable to resolve IP address by '{}'", (Object)address, (Object)e);
            }
        }
        return null;
    }
}

