/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.node.single;

import com.github.msemys.esjc.util.Preconditions;
import java.net.InetSocketAddress;

public class SingleNodeSettings {
    public final InetSocketAddress address;

    private SingleNodeSettings(Builder builder) {
        this.address = builder.address;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SingleNodeSettings{");
        sb.append("address=").append(this.address);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        private InetSocketAddress address;

        public Builder address(String host, int port) {
            return this.address(InetSocketAddress.createUnresolved(host, port));
        }

        public Builder address(InetSocketAddress address) {
            this.address = address;
            return this;
        }

        public SingleNodeSettings build() {
            Preconditions.checkNotNull(this.address, "address is null");
            return new SingleNodeSettings(this);
        }
    }
}

