/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.operation;

import com.github.msemys.esjc.UserCredentials;
import com.github.msemys.esjc.operation.CommandNotExpectedException;
import com.github.msemys.esjc.operation.InspectionDecision;
import com.github.msemys.esjc.operation.InspectionResult;
import com.github.msemys.esjc.operation.NoResultException;
import com.github.msemys.esjc.operation.NotAuthenticatedException;
import com.github.msemys.esjc.operation.Operation;
import com.github.msemys.esjc.operation.ServerErrorException;
import com.github.msemys.esjc.proto.EventStoreClientMessages;
import com.github.msemys.esjc.tcp.TcpCommand;
import com.github.msemys.esjc.tcp.TcpFlag;
import com.github.msemys.esjc.tcp.TcpPackage;
import com.github.msemys.esjc.util.Preconditions;
import com.github.msemys.esjc.util.Strings;
import com.github.msemys.esjc.util.Throwables;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperation<T, R extends MessageLite>
implements Operation {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final TcpCommand requestCommand;
    private final TcpCommand responseCommand;
    protected final UserCredentials userCredentials;
    private final CompletableFuture<T> result;
    private R responseMessage;
    private final AtomicBoolean completed = new AtomicBoolean(false);

    protected AbstractOperation(CompletableFuture<T> result, TcpCommand requestCommand, TcpCommand responseCommand, UserCredentials userCredentials) {
        this.result = result;
        this.requestCommand = requestCommand;
        this.responseCommand = responseCommand;
        this.userCredentials = userCredentials;
    }

    protected abstract MessageLite createRequestMessage();

    protected abstract R createResponseMessage();

    protected abstract InspectionResult inspectResponseMessage(R var1);

    protected abstract T transformResponseMessage(R var1);

    @Override
    public TcpPackage create(UUID correlationId) {
        return TcpPackage.newBuilder().command(this.requestCommand).flag(this.userCredentials != null ? TcpFlag.Authenticated : TcpFlag.None).correlationId(correlationId).login(this.userCredentials != null ? this.userCredentials.username : null).password(this.userCredentials != null ? this.userCredentials.password : null).data(this.createRequestMessage().toByteArray()).build();
    }

    @Override
    public InspectionResult inspect(TcpPackage tcpPackage) {
        try {
            if (tcpPackage.command == this.responseCommand) {
                this.responseMessage = (MessageLite)this.createResponseMessage().getParserForType().parseFrom(tcpPackage.data);
                return this.inspectResponseMessage(this.responseMessage);
            }
            switch (tcpPackage.command) {
                case NotAuthenticated: {
                    return this.inspectNotAuthenticated(tcpPackage);
                }
                case BadRequest: {
                    return this.inspectBadRequest(tcpPackage);
                }
                case NotHandled: {
                    return this.inspectNotHandled(tcpPackage);
                }
            }
            return this.inspectUnexpectedCommand(tcpPackage, this.responseCommand);
        }
        catch (Exception e) {
            this.fail(e);
            return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("Exception - " + e.getMessage()).build();
        }
    }

    private InspectionResult inspectNotAuthenticated(TcpPackage tcpPackage) {
        String message = Strings.newString(tcpPackage.data);
        this.fail(new NotAuthenticatedException(Strings.defaultIfEmpty(message, "Authentication error")));
        return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("NotAuthenticated").build();
    }

    private InspectionResult inspectBadRequest(TcpPackage tcpPackage) {
        String message = Strings.newString(tcpPackage.data);
        this.fail(new ServerErrorException(Strings.defaultIfEmpty(message, "<no message>")));
        return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("BadRequest - " + message).build();
    }

    private InspectionResult inspectNotHandled(TcpPackage tcpPackage) {
        try {
            EventStoreClientMessages.NotHandled message = EventStoreClientMessages.NotHandled.parseFrom(tcpPackage.data);
            switch (message.getReason()) {
                case NotReady: {
                    return InspectionResult.newBuilder().decision(InspectionDecision.Retry).description("NotHandled - NotReady").build();
                }
                case TooBusy: {
                    return InspectionResult.newBuilder().decision(InspectionDecision.Retry).description("NotHandled - TooBusy").build();
                }
                case NotMaster: {
                    EventStoreClientMessages.NotHandled.MasterInfo masterInfo = EventStoreClientMessages.NotHandled.MasterInfo.parseFrom(message.getAdditionalInfo().toByteArray());
                    return InspectionResult.newBuilder().decision(InspectionDecision.Reconnect).description("NotHandled - NotMaster").address(masterInfo.getExternalTcpAddress(), masterInfo.getExternalTcpPort()).secureAddress(masterInfo.getExternalSecureTcpAddress(), masterInfo.getExternalSecureTcpPort()).build();
                }
            }
            this.logger.error("Unknown NotHandledReason: {}.", (Object)message.getReason());
            return InspectionResult.newBuilder().decision(InspectionDecision.Retry).description("NotHandled - <unknown>").build();
        }
        catch (InvalidProtocolBufferException e) {
            throw Throwables.propagate(e);
        }
    }

    private InspectionResult inspectUnexpectedCommand(TcpPackage tcpPackage, TcpCommand expectedCommand) {
        Preconditions.checkArgument(tcpPackage.command != expectedCommand, "Command should not be %s.", new Object[]{tcpPackage.command});
        this.logger.error("Unexpected TcpCommand received.\nExpected: {}, Actual: {}, Flags: {}, CorrelationId: {}\nOperation ({}): {}\nTcpPackage Data Dump:\n{}", new Object[]{expectedCommand, tcpPackage.command, tcpPackage.flag, tcpPackage.correlationId, this.getClass().getSimpleName(), this, ByteBufUtil.prettyHexDump((ByteBuf)Unpooled.wrappedBuffer((byte[])tcpPackage.data))});
        this.fail(new CommandNotExpectedException(expectedCommand, tcpPackage.command));
        return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("Unexpected command - " + (Object)((Object)tcpPackage.command)).build();
    }

    protected void succeed() {
        if (this.completed.compareAndSet(false, true)) {
            if (this.responseMessage != null) {
                this.result.complete(this.transformResponseMessage(this.responseMessage));
            } else {
                this.result.completeExceptionally(new NoResultException());
            }
        }
    }

    @Override
    public void fail(Exception exception) {
        if (this.completed.compareAndSet(false, true)) {
            this.result.completeExceptionally(exception);
        }
    }
}

