/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.operation;

import com.github.msemys.esjc.Position;
import com.github.msemys.esjc.UserCredentials;
import com.github.msemys.esjc.WriteResult;
import com.github.msemys.esjc.operation.AbstractOperation;
import com.github.msemys.esjc.operation.AccessDeniedException;
import com.github.msemys.esjc.operation.InspectionDecision;
import com.github.msemys.esjc.operation.InspectionResult;
import com.github.msemys.esjc.operation.InvalidTransactionException;
import com.github.msemys.esjc.operation.StreamDeletedException;
import com.github.msemys.esjc.operation.WrongExpectedVersionException;
import com.github.msemys.esjc.proto.EventStoreClientMessages;
import com.github.msemys.esjc.tcp.TcpCommand;
import com.google.protobuf.MessageLite;
import java.util.concurrent.CompletableFuture;

public class CommitTransactionOperation
extends AbstractOperation<WriteResult, EventStoreClientMessages.TransactionCommitCompleted> {
    private final boolean requireMaster;
    private final long transactionId;

    public CommitTransactionOperation(CompletableFuture<WriteResult> result, boolean requireMaster, long transactionId, UserCredentials userCredentials) {
        super(result, TcpCommand.TransactionCommit, TcpCommand.TransactionCommitCompleted, userCredentials);
        this.requireMaster = requireMaster;
        this.transactionId = transactionId;
    }

    @Override
    protected MessageLite createRequestMessage() {
        return EventStoreClientMessages.TransactionCommit.newBuilder().setTransactionId(this.transactionId).setRequireMaster(this.requireMaster).build();
    }

    @Override
    protected EventStoreClientMessages.TransactionCommitCompleted createResponseMessage() {
        return EventStoreClientMessages.TransactionCommitCompleted.getDefaultInstance();
    }

    @Override
    protected InspectionResult inspectResponseMessage(EventStoreClientMessages.TransactionCommitCompleted response) {
        switch (response.getResult()) {
            case Success: {
                this.succeed();
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("Success").build();
            }
            case PrepareTimeout: {
                return InspectionResult.newBuilder().decision(InspectionDecision.Retry).description("PrepareTimeout").build();
            }
            case CommitTimeout: {
                return InspectionResult.newBuilder().decision(InspectionDecision.Retry).description("CommitTimeout").build();
            }
            case ForwardTimeout: {
                return InspectionResult.newBuilder().decision(InspectionDecision.Retry).description("ForwardTimeout").build();
            }
            case WrongExpectedVersion: {
                this.fail(new WrongExpectedVersionException(String.format("Commit transaction failed due to WrongExpectedVersion. TransactionID: %s.", this.transactionId)));
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("WrongExpectedVersion").build();
            }
            case StreamDeleted: {
                this.fail(new StreamDeletedException());
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("StreamDeleted").build();
            }
            case InvalidTransaction: {
                this.fail(new InvalidTransactionException());
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("InvalidTransaction").build();
            }
            case AccessDenied: {
                this.fail(new AccessDeniedException("Write access denied."));
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("AccessDenied").build();
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected OperationResult: %s.", new Object[]{response.getResult()}));
    }

    @Override
    protected WriteResult transformResponseMessage(EventStoreClientMessages.TransactionCommitCompleted response) {
        long commitPosition = response.hasCommitPosition() ? response.getCommitPosition() : -1L;
        long preparePosition = response.hasPreparePosition() ? response.getPreparePosition() : -1L;
        return new WriteResult(response.getLastEventNumber(), new Position(commitPosition, preparePosition));
    }

    public String toString() {
        return String.format("TransactionId: %s", this.transactionId);
    }
}

