/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.operation;

import com.github.msemys.esjc.PersistentSubscriptionDeleteResult;
import com.github.msemys.esjc.PersistentSubscriptionDeleteStatus;
import com.github.msemys.esjc.UserCredentials;
import com.github.msemys.esjc.operation.AbstractOperation;
import com.github.msemys.esjc.operation.AccessDeniedException;
import com.github.msemys.esjc.operation.InspectionDecision;
import com.github.msemys.esjc.operation.InspectionResult;
import com.github.msemys.esjc.proto.EventStoreClientMessages;
import com.github.msemys.esjc.tcp.TcpCommand;
import com.google.protobuf.MessageLite;
import java.util.concurrent.CompletableFuture;

public class DeletePersistentSubscriptionOperation
extends AbstractOperation<PersistentSubscriptionDeleteResult, EventStoreClientMessages.DeletePersistentSubscriptionCompleted> {
    private final String stream;
    private final String groupName;

    public DeletePersistentSubscriptionOperation(CompletableFuture<PersistentSubscriptionDeleteResult> result, String stream, String groupName, UserCredentials userCredentials) {
        super(result, TcpCommand.DeletePersistentSubscription, TcpCommand.DeletePersistentSubscriptionCompleted, userCredentials);
        this.stream = stream;
        this.groupName = groupName;
    }

    @Override
    protected MessageLite createRequestMessage() {
        return EventStoreClientMessages.DeletePersistentSubscription.newBuilder().setEventStreamId(this.stream).setSubscriptionGroupName(this.groupName).build();
    }

    @Override
    protected EventStoreClientMessages.DeletePersistentSubscriptionCompleted createResponseMessage() {
        return EventStoreClientMessages.DeletePersistentSubscriptionCompleted.getDefaultInstance();
    }

    @Override
    protected InspectionResult inspectResponseMessage(EventStoreClientMessages.DeletePersistentSubscriptionCompleted response) {
        switch (response.getResult()) {
            case Success: {
                this.succeed();
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("Success").build();
            }
            case Fail: {
                this.fail(new IllegalStateException(String.format("Subscription group %s on stream %s failed '%s'", this.groupName, this.stream, response.getReason())));
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("Fail").build();
            }
            case AccessDenied: {
                this.fail(new AccessDeniedException(String.format("Write access denied for stream '%s'.", this.stream)));
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("AccessDenied").build();
            }
            case DoesNotExist: {
                this.fail(new IllegalStateException(String.format("Subscription group %s on stream %s does not exist", this.groupName, this.stream)));
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("DoesNotExist").build();
            }
        }
        throw new IllegalArgumentException("Unexpected OperationResult: " + (Object)((Object)response.getResult()));
    }

    @Override
    protected PersistentSubscriptionDeleteResult transformResponseMessage(EventStoreClientMessages.DeletePersistentSubscriptionCompleted response) {
        return new PersistentSubscriptionDeleteResult(PersistentSubscriptionDeleteStatus.Success);
    }

    public String toString() {
        return String.format("Stream: %s, Group Name: %s", this.stream, this.groupName);
    }
}

