/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.operation;

import com.github.msemys.esjc.DeleteResult;
import com.github.msemys.esjc.Position;
import com.github.msemys.esjc.UserCredentials;
import com.github.msemys.esjc.operation.AbstractOperation;
import com.github.msemys.esjc.operation.AccessDeniedException;
import com.github.msemys.esjc.operation.InspectionDecision;
import com.github.msemys.esjc.operation.InspectionResult;
import com.github.msemys.esjc.operation.InvalidTransactionException;
import com.github.msemys.esjc.operation.StreamDeletedException;
import com.github.msemys.esjc.operation.WrongExpectedVersionException;
import com.github.msemys.esjc.proto.EventStoreClientMessages;
import com.github.msemys.esjc.tcp.TcpCommand;
import com.google.protobuf.MessageLite;
import java.util.concurrent.CompletableFuture;

public class DeleteStreamOperation
extends AbstractOperation<DeleteResult, EventStoreClientMessages.DeleteStreamCompleted> {
    private final boolean requireMaster;
    private final String stream;
    private final long expectedVersion;
    private final boolean hardDelete;

    public DeleteStreamOperation(CompletableFuture<DeleteResult> result, boolean requireMaster, String stream, long expectedVersion, boolean hardDelete, UserCredentials userCredentials) {
        super(result, TcpCommand.DeleteStream, TcpCommand.DeleteStreamCompleted, userCredentials);
        this.requireMaster = requireMaster;
        this.stream = stream;
        this.expectedVersion = expectedVersion;
        this.hardDelete = hardDelete;
    }

    @Override
    protected MessageLite createRequestMessage() {
        return EventStoreClientMessages.DeleteStream.newBuilder().setEventStreamId(this.stream).setExpectedVersion(this.expectedVersion).setRequireMaster(this.requireMaster).setHardDelete(this.hardDelete).build();
    }

    @Override
    protected EventStoreClientMessages.DeleteStreamCompleted createResponseMessage() {
        return EventStoreClientMessages.DeleteStreamCompleted.getDefaultInstance();
    }

    @Override
    protected InspectionResult inspectResponseMessage(EventStoreClientMessages.DeleteStreamCompleted response) {
        switch (response.getResult()) {
            case Success: {
                this.succeed();
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("Success").build();
            }
            case PrepareTimeout: {
                return InspectionResult.newBuilder().decision(InspectionDecision.Retry).description("PrepareTimeout").build();
            }
            case CommitTimeout: {
                return InspectionResult.newBuilder().decision(InspectionDecision.Retry).description("CommitTimeout").build();
            }
            case ForwardTimeout: {
                return InspectionResult.newBuilder().decision(InspectionDecision.Retry).description("ForwardTimeout").build();
            }
            case WrongExpectedVersion: {
                this.fail(new WrongExpectedVersionException("Delete stream failed due to WrongExpectedVersion. Stream: %s, Expected version: %d.", this.stream, this.expectedVersion));
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("WrongExpectedVersion").build();
            }
            case StreamDeleted: {
                this.fail(new StreamDeletedException(this.stream));
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("StreamDeleted").build();
            }
            case InvalidTransaction: {
                this.fail(new InvalidTransactionException());
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("InvalidTransaction").build();
            }
            case AccessDenied: {
                this.fail(new AccessDeniedException(String.format("Write access denied for stream '%s'.", this.stream)));
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("AccessDenied").build();
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected OperationResult: %s.", new Object[]{response.getResult()}));
    }

    @Override
    protected DeleteResult transformResponseMessage(EventStoreClientMessages.DeleteStreamCompleted response) {
        long commitPosition = response.hasCommitPosition() ? response.getCommitPosition() : -1L;
        long preparePosition = response.hasPreparePosition() ? response.getPreparePosition() : -1L;
        return new DeleteResult(new Position(commitPosition, preparePosition));
    }

    public String toString() {
        return String.format("Stream: %s, ExpectedVersion: %d.", this.stream, this.expectedVersion);
    }
}

