/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.operation;

import com.github.msemys.esjc.operation.InspectionDecision;
import com.github.msemys.esjc.util.Preconditions;
import java.net.InetSocketAddress;

public class InspectionResult {
    public final InspectionDecision decision;
    public final String description;
    public final InetSocketAddress address;
    public final InetSocketAddress secureAddress;

    private InspectionResult(Builder builder) {
        this.decision = builder.decision;
        this.description = builder.description;
        this.address = builder.address;
        this.secureAddress = builder.secureAddress;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private InspectionDecision decision;
        private String description;
        private InetSocketAddress address;
        private InetSocketAddress secureAddress;

        private Builder() {
        }

        public Builder decision(InspectionDecision decision) {
            this.decision = decision;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder address(String hostname, int port) {
            this.address = new InetSocketAddress(hostname, port);
            return this;
        }

        public Builder secureAddress(String hostname, int port) {
            this.secureAddress = new InetSocketAddress(hostname, port);
            return this;
        }

        public InspectionResult build() {
            Preconditions.checkNotNull(this.decision, "Decision not specified.");
            Preconditions.checkNotNull(this.description, "Description not specified.");
            if (this.decision == InspectionDecision.Reconnect) {
                Preconditions.checkNotNull(this.address, "Address not specified.");
            } else {
                Preconditions.checkArgument(this.address == null, "Address is specified for decision %s.", new Object[]{this.decision});
            }
            return new InspectionResult(this);
        }
    }
}

