/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.operation;

import com.github.msemys.esjc.AllEventsSlice;
import com.github.msemys.esjc.Position;
import com.github.msemys.esjc.ReadDirection;
import com.github.msemys.esjc.UserCredentials;
import com.github.msemys.esjc.operation.AbstractOperation;
import com.github.msemys.esjc.operation.AccessDeniedException;
import com.github.msemys.esjc.operation.InspectionDecision;
import com.github.msemys.esjc.operation.InspectionResult;
import com.github.msemys.esjc.operation.ServerErrorException;
import com.github.msemys.esjc.proto.EventStoreClientMessages;
import com.github.msemys.esjc.tcp.TcpCommand;
import com.github.msemys.esjc.util.Strings;
import com.google.protobuf.MessageLite;
import java.util.concurrent.CompletableFuture;

public class ReadAllEventsBackwardOperation
extends AbstractOperation<AllEventsSlice, EventStoreClientMessages.ReadAllEventsCompleted> {
    private final Position position;
    private final int maxCount;
    private final boolean resolveLinkTos;
    private final boolean requireMaster;

    public ReadAllEventsBackwardOperation(CompletableFuture<AllEventsSlice> result, Position position, int maxCount, boolean resolveLinkTos, boolean requireMaster, UserCredentials userCredentials) {
        super(result, TcpCommand.ReadAllEventsBackward, TcpCommand.ReadAllEventsBackwardCompleted, userCredentials);
        this.position = position;
        this.maxCount = maxCount;
        this.resolveLinkTos = resolveLinkTos;
        this.requireMaster = requireMaster;
    }

    @Override
    protected MessageLite createRequestMessage() {
        return EventStoreClientMessages.ReadAllEvents.newBuilder().setCommitPosition(this.position.commitPosition).setPreparePosition(this.position.preparePosition).setMaxCount(this.maxCount).setResolveLinkTos(this.resolveLinkTos).setRequireMaster(this.requireMaster).build();
    }

    @Override
    protected EventStoreClientMessages.ReadAllEventsCompleted createResponseMessage() {
        return EventStoreClientMessages.ReadAllEventsCompleted.getDefaultInstance();
    }

    @Override
    protected InspectionResult inspectResponseMessage(EventStoreClientMessages.ReadAllEventsCompleted response) {
        switch (response.getResult()) {
            case Success: {
                this.succeed();
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("Success").build();
            }
            case Error: {
                this.fail(new ServerErrorException(Strings.defaultIfEmpty(response.getError(), "<no message>")));
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("Error").build();
            }
            case AccessDenied: {
                this.fail(new AccessDeniedException("Read access denied for $all."));
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("Error").build();
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected ReadAllResult: %s.", new Object[]{response.getResult()}));
    }

    @Override
    protected AllEventsSlice transformResponseMessage(EventStoreClientMessages.ReadAllEventsCompleted response) {
        return new AllEventsSlice(ReadDirection.Backward, new Position(response.getCommitPosition(), response.getPreparePosition()), new Position(response.getNextCommitPosition(), response.getNextPreparePosition()), response.getEventsList());
    }

    public String toString() {
        return String.format("Position: %s, MaxCount: %d, ResolveLinkTos: %s, RequireMaster: %s", this.position, this.maxCount, this.resolveLinkTos, this.requireMaster);
    }
}

