/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.operation;

import com.github.msemys.esjc.EventReadResult;
import com.github.msemys.esjc.EventReadStatus;
import com.github.msemys.esjc.UserCredentials;
import com.github.msemys.esjc.operation.AbstractOperation;
import com.github.msemys.esjc.operation.AccessDeniedException;
import com.github.msemys.esjc.operation.InspectionDecision;
import com.github.msemys.esjc.operation.InspectionResult;
import com.github.msemys.esjc.operation.ServerErrorException;
import com.github.msemys.esjc.proto.EventStoreClientMessages;
import com.github.msemys.esjc.tcp.TcpCommand;
import com.github.msemys.esjc.util.Strings;
import com.google.protobuf.MessageLite;
import java.util.concurrent.CompletableFuture;

public class ReadEventOperation
extends AbstractOperation<EventReadResult, EventStoreClientMessages.ReadEventCompleted> {
    private final String stream;
    private final long eventNumber;
    private final boolean resolveLinkTo;
    private final boolean requireMaster;

    public ReadEventOperation(CompletableFuture<EventReadResult> result, String stream, long eventNumber, boolean resolveLinkTo, boolean requireMaster, UserCredentials userCredentials) {
        super(result, TcpCommand.ReadEvent, TcpCommand.ReadEventCompleted, userCredentials);
        this.stream = stream;
        this.eventNumber = eventNumber;
        this.resolveLinkTo = resolveLinkTo;
        this.requireMaster = requireMaster;
    }

    @Override
    protected MessageLite createRequestMessage() {
        return EventStoreClientMessages.ReadEvent.newBuilder().setEventStreamId(this.stream).setEventNumber(this.eventNumber).setResolveLinkTos(this.resolveLinkTo).setRequireMaster(this.requireMaster).build();
    }

    @Override
    protected EventStoreClientMessages.ReadEventCompleted createResponseMessage() {
        return EventStoreClientMessages.ReadEventCompleted.getDefaultInstance();
    }

    @Override
    protected InspectionResult inspectResponseMessage(EventStoreClientMessages.ReadEventCompleted response) {
        switch (response.getResult()) {
            case Success: {
                this.succeed();
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("Success").build();
            }
            case NotFound: {
                this.succeed();
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("NotFound").build();
            }
            case NoStream: {
                this.succeed();
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("NoStream").build();
            }
            case StreamDeleted: {
                this.succeed();
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("StreamDeleted").build();
            }
            case Error: {
                this.fail(new ServerErrorException(Strings.defaultIfEmpty(response.getError(), "<no message>")));
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("Error").build();
            }
            case AccessDenied: {
                this.fail(new AccessDeniedException(String.format("Read access denied for stream '%s'.", this.stream)));
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("AccessDenied").build();
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected OperationResult: %s.", new Object[]{response.getResult()}));
    }

    @Override
    protected EventReadResult transformResponseMessage(EventStoreClientMessages.ReadEventCompleted response) {
        return new EventReadResult(ReadEventOperation.asEventReadStatus(response.getResult()), this.stream, this.eventNumber, response.getEvent());
    }

    public String toString() {
        return String.format("Stream: %s, EventNumber: %d, ResolveLinkTo: %s, RequireMaster: %s", this.stream, this.eventNumber, this.resolveLinkTo, this.requireMaster);
    }

    private static EventReadStatus asEventReadStatus(EventStoreClientMessages.ReadEventCompleted.ReadEventResult result) {
        switch (result) {
            case Success: {
                return EventReadStatus.Success;
            }
            case NotFound: {
                return EventReadStatus.NotFound;
            }
            case NoStream: {
                return EventReadStatus.NoStream;
            }
            case StreamDeleted: {
                return EventReadStatus.StreamDeleted;
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected ReadEventResult: %s.", new Object[]{result}));
    }
}

