/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.operation;

import com.github.msemys.esjc.ReadDirection;
import com.github.msemys.esjc.SliceReadStatus;
import com.github.msemys.esjc.StreamEventsSlice;
import com.github.msemys.esjc.UserCredentials;
import com.github.msemys.esjc.operation.AbstractOperation;
import com.github.msemys.esjc.operation.AccessDeniedException;
import com.github.msemys.esjc.operation.InspectionDecision;
import com.github.msemys.esjc.operation.InspectionResult;
import com.github.msemys.esjc.operation.ServerErrorException;
import com.github.msemys.esjc.proto.EventStoreClientMessages;
import com.github.msemys.esjc.tcp.TcpCommand;
import com.github.msemys.esjc.util.Strings;
import com.google.protobuf.MessageLite;
import java.util.concurrent.CompletableFuture;

public class ReadStreamEventsBackwardOperation
extends AbstractOperation<StreamEventsSlice, EventStoreClientMessages.ReadStreamEventsCompleted> {
    private final String stream;
    private final long fromEventNumber;
    private final int maxCount;
    private final boolean resolveLinkTos;
    private final boolean requireMaster;

    public ReadStreamEventsBackwardOperation(CompletableFuture<StreamEventsSlice> result, String stream, long fromEventNumber, int maxCount, boolean resolveLinkTos, boolean requireMaster, UserCredentials userCredentials) {
        super(result, TcpCommand.ReadStreamEventsBackward, TcpCommand.ReadStreamEventsBackwardCompleted, userCredentials);
        this.stream = stream;
        this.fromEventNumber = fromEventNumber;
        this.maxCount = maxCount;
        this.resolveLinkTos = resolveLinkTos;
        this.requireMaster = requireMaster;
    }

    @Override
    protected MessageLite createRequestMessage() {
        return EventStoreClientMessages.ReadStreamEvents.newBuilder().setEventStreamId(this.stream).setFromEventNumber(this.fromEventNumber).setMaxCount(this.maxCount).setResolveLinkTos(this.resolveLinkTos).setRequireMaster(this.requireMaster).build();
    }

    @Override
    protected EventStoreClientMessages.ReadStreamEventsCompleted createResponseMessage() {
        return EventStoreClientMessages.ReadStreamEventsCompleted.getDefaultInstance();
    }

    @Override
    protected InspectionResult inspectResponseMessage(EventStoreClientMessages.ReadStreamEventsCompleted response) {
        switch (response.getResult()) {
            case Success: {
                this.succeed();
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("Success").build();
            }
            case StreamDeleted: {
                this.succeed();
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("StreamDeleted").build();
            }
            case NoStream: {
                this.succeed();
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("NoStream").build();
            }
            case Error: {
                this.fail(new ServerErrorException(Strings.defaultIfEmpty(response.getError(), "<no message>")));
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("Error").build();
            }
            case AccessDenied: {
                this.fail(new AccessDeniedException(String.format("Read access denied for stream '%s'.", this.stream)));
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("AccessDenied").build();
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected ReadStreamResult: %s.", new Object[]{response.getResult()}));
    }

    @Override
    protected StreamEventsSlice transformResponseMessage(EventStoreClientMessages.ReadStreamEventsCompleted response) {
        return new StreamEventsSlice(ReadStreamEventsBackwardOperation.asSliceReadStatus(response.getResult()), this.stream, this.fromEventNumber, ReadDirection.Backward, response.getEventsList(), response.getNextEventNumber(), response.getLastEventNumber(), response.getIsEndOfStream());
    }

    public String toString() {
        return String.format("Stream: %s, FromEventNumber: %s, MaxCount: %d, ResolveLinkTos: %s, RequireMaster: %s", this.stream, this.fromEventNumber, this.maxCount, this.resolveLinkTos, this.requireMaster);
    }

    private static SliceReadStatus asSliceReadStatus(EventStoreClientMessages.ReadStreamEventsCompleted.ReadStreamResult result) {
        switch (result) {
            case Success: {
                return SliceReadStatus.Success;
            }
            case NoStream: {
                return SliceReadStatus.StreamNotFound;
            }
            case StreamDeleted: {
                return SliceReadStatus.StreamDeleted;
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected ReadStreamResult: %s.", new Object[]{result}));
    }
}

