/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.operation;

import com.github.msemys.esjc.Transaction;
import com.github.msemys.esjc.UserCredentials;
import com.github.msemys.esjc.operation.AbstractOperation;
import com.github.msemys.esjc.operation.AccessDeniedException;
import com.github.msemys.esjc.operation.InspectionDecision;
import com.github.msemys.esjc.operation.InspectionResult;
import com.github.msemys.esjc.operation.InvalidTransactionException;
import com.github.msemys.esjc.operation.StreamDeletedException;
import com.github.msemys.esjc.operation.WrongExpectedVersionException;
import com.github.msemys.esjc.proto.EventStoreClientMessages;
import com.github.msemys.esjc.tcp.TcpCommand;
import com.github.msemys.esjc.transaction.TransactionManager;
import com.google.protobuf.MessageLite;
import java.util.concurrent.CompletableFuture;

public class StartTransactionOperation
extends AbstractOperation<Transaction, EventStoreClientMessages.TransactionStartCompleted> {
    private final boolean requireMaster;
    private final String stream;
    private final long expectedVersion;
    private final TransactionManager transactionManager;

    public StartTransactionOperation(CompletableFuture<Transaction> result, boolean requireMaster, String stream, long expectedVersion, TransactionManager transactionManager, UserCredentials userCredentials) {
        super(result, TcpCommand.TransactionStart, TcpCommand.TransactionStartCompleted, userCredentials);
        this.requireMaster = requireMaster;
        this.stream = stream;
        this.expectedVersion = expectedVersion;
        this.transactionManager = transactionManager;
    }

    @Override
    protected MessageLite createRequestMessage() {
        return EventStoreClientMessages.TransactionStart.newBuilder().setEventStreamId(this.stream).setExpectedVersion(this.expectedVersion).setRequireMaster(this.requireMaster).build();
    }

    @Override
    protected EventStoreClientMessages.TransactionStartCompleted createResponseMessage() {
        return EventStoreClientMessages.TransactionStartCompleted.getDefaultInstance();
    }

    @Override
    protected InspectionResult inspectResponseMessage(EventStoreClientMessages.TransactionStartCompleted response) {
        switch (response.getResult()) {
            case Success: {
                this.succeed();
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("Success").build();
            }
            case PrepareTimeout: {
                return InspectionResult.newBuilder().decision(InspectionDecision.Retry).description("PrepareTimeout").build();
            }
            case CommitTimeout: {
                return InspectionResult.newBuilder().decision(InspectionDecision.Retry).description("CommitTimeout").build();
            }
            case ForwardTimeout: {
                return InspectionResult.newBuilder().decision(InspectionDecision.Retry).description("ForwardTimeout").build();
            }
            case WrongExpectedVersion: {
                this.fail(new WrongExpectedVersionException("Start transaction failed due to WrongExpectedVersion. Stream: %s, Expected version: %d.", this.stream, this.expectedVersion));
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("WrongExpectedVersion").build();
            }
            case StreamDeleted: {
                this.fail(new StreamDeletedException(this.stream));
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("StreamDeleted").build();
            }
            case InvalidTransaction: {
                this.fail(new InvalidTransactionException());
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("InvalidTransaction").build();
            }
            case AccessDenied: {
                this.fail(new AccessDeniedException(String.format("Write access denied for stream '%s'.", this.stream)));
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("AccessDenied").build();
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected OperationResult: %s.", new Object[]{response.getResult()}));
    }

    @Override
    protected Transaction transformResponseMessage(EventStoreClientMessages.TransactionStartCompleted response) {
        return new Transaction(response.getTransactionId(), this.userCredentials, this.transactionManager);
    }

    public String toString() {
        return String.format("Stream: %s, ExpectedVersion: %d", this.stream, this.expectedVersion);
    }
}

