/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.operation;

import com.github.msemys.esjc.EventData;
import com.github.msemys.esjc.UserCredentials;
import com.github.msemys.esjc.operation.AbstractOperation;
import com.github.msemys.esjc.operation.AccessDeniedException;
import com.github.msemys.esjc.operation.InspectionDecision;
import com.github.msemys.esjc.operation.InspectionResult;
import com.github.msemys.esjc.proto.EventStoreClientMessages;
import com.github.msemys.esjc.tcp.TcpCommand;
import com.github.msemys.esjc.util.UUIDConverter;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;

public class TransactionalWriteOperation
extends AbstractOperation<Void, EventStoreClientMessages.TransactionWriteCompleted> {
    private final boolean requireMaster;
    private final long transactionId;
    private final Iterable<EventData> events;

    public TransactionalWriteOperation(CompletableFuture<Void> result, boolean requireMaster, long transactionId, Iterable<EventData> events, UserCredentials userCredentials) {
        super(result, TcpCommand.TransactionWrite, TcpCommand.TransactionWriteCompleted, userCredentials);
        this.requireMaster = requireMaster;
        this.transactionId = transactionId;
        this.events = events;
    }

    @Override
    protected MessageLite createRequestMessage() {
        ArrayList newEvents = new ArrayList();
        this.events.forEach(e -> newEvents.add(EventStoreClientMessages.NewEvent.newBuilder().setEventId(ByteString.copyFrom((byte[])UUIDConverter.toBytes(e.eventId))).setEventType(e.type).setDataContentType(e.isJsonData ? 1 : 0).setMetadataContentType(e.isJsonMetadata ? 1 : 0).setData(ByteString.copyFrom((byte[])e.data)).setMetadata(ByteString.copyFrom((byte[])e.metadata)).build()));
        return EventStoreClientMessages.TransactionWrite.newBuilder().setTransactionId(this.transactionId).setRequireMaster(this.requireMaster).addAllEvents(newEvents).build();
    }

    @Override
    protected EventStoreClientMessages.TransactionWriteCompleted createResponseMessage() {
        return EventStoreClientMessages.TransactionWriteCompleted.getDefaultInstance();
    }

    @Override
    protected InspectionResult inspectResponseMessage(EventStoreClientMessages.TransactionWriteCompleted response) {
        switch (response.getResult()) {
            case Success: {
                this.succeed();
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("Success").build();
            }
            case PrepareTimeout: {
                return InspectionResult.newBuilder().decision(InspectionDecision.Retry).description("PrepareTimeout").build();
            }
            case CommitTimeout: {
                return InspectionResult.newBuilder().decision(InspectionDecision.Retry).description("CommitTimeout").build();
            }
            case ForwardTimeout: {
                return InspectionResult.newBuilder().decision(InspectionDecision.Retry).description("ForwardTimeout").build();
            }
            case AccessDenied: {
                this.fail(new AccessDeniedException("Write access denied."));
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("AccessDenied").build();
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected OperationResult: %s.", new Object[]{response.getResult()}));
    }

    @Override
    protected Void transformResponseMessage(EventStoreClientMessages.TransactionWriteCompleted response) {
        return null;
    }

    public String toString() {
        return "TransactionId: " + this.transactionId;
    }
}

