/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.operation;

import com.github.msemys.esjc.EventData;
import com.github.msemys.esjc.Position;
import com.github.msemys.esjc.UserCredentials;
import com.github.msemys.esjc.WriteAttemptResult;
import com.github.msemys.esjc.WriteStatus;
import com.github.msemys.esjc.operation.AbstractOperation;
import com.github.msemys.esjc.operation.AccessDeniedException;
import com.github.msemys.esjc.operation.InspectionDecision;
import com.github.msemys.esjc.operation.InspectionResult;
import com.github.msemys.esjc.operation.InvalidTransactionException;
import com.github.msemys.esjc.proto.EventStoreClientMessages;
import com.github.msemys.esjc.tcp.TcpCommand;
import com.github.msemys.esjc.util.UUIDConverter;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TryAppendToStreamOperation
extends AbstractOperation<WriteAttemptResult, EventStoreClientMessages.WriteEventsCompleted> {
    private static final Logger logger = LoggerFactory.getLogger(TryAppendToStreamOperation.class);
    private final boolean requireMaster;
    private final String stream;
    private final long expectedVersion;
    private final Iterable<EventData> events;
    private boolean wasCommitTimeout;

    public TryAppendToStreamOperation(CompletableFuture<WriteAttemptResult> result, boolean requireMaster, String stream, long expectedVersion, Iterable<EventData> events, UserCredentials userCredentials) {
        super(result, TcpCommand.WriteEvents, TcpCommand.WriteEventsCompleted, userCredentials);
        this.requireMaster = requireMaster;
        this.stream = stream;
        this.expectedVersion = expectedVersion;
        this.events = events;
    }

    @Override
    protected MessageLite createRequestMessage() {
        ArrayList newEvents = new ArrayList();
        this.events.forEach(e -> newEvents.add(EventStoreClientMessages.NewEvent.newBuilder().setEventId(ByteString.copyFrom((byte[])UUIDConverter.toBytes(e.eventId))).setEventType(e.type).setDataContentType(e.isJsonData ? 1 : 0).setMetadataContentType(e.isJsonMetadata ? 1 : 0).setData(ByteString.copyFrom((byte[])e.data)).setMetadata(ByteString.copyFrom((byte[])e.metadata)).build()));
        return EventStoreClientMessages.WriteEvents.newBuilder().setEventStreamId(this.stream).setExpectedVersion(this.expectedVersion).setRequireMaster(this.requireMaster).addAllEvents(newEvents).build();
    }

    @Override
    protected EventStoreClientMessages.WriteEventsCompleted createResponseMessage() {
        return EventStoreClientMessages.WriteEventsCompleted.getDefaultInstance();
    }

    @Override
    protected InspectionResult inspectResponseMessage(EventStoreClientMessages.WriteEventsCompleted response) {
        switch (response.getResult()) {
            case Success: {
                if (this.wasCommitTimeout) {
                    logger.debug("IDEMPOTENT WRITE SUCCEEDED FOR {}.", (Object)this);
                }
                this.succeed();
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("Success").build();
            }
            case PrepareTimeout: {
                return InspectionResult.newBuilder().decision(InspectionDecision.Retry).description("PrepareTimeout").build();
            }
            case ForwardTimeout: {
                return InspectionResult.newBuilder().decision(InspectionDecision.Retry).description("ForwardTimeout").build();
            }
            case CommitTimeout: {
                this.wasCommitTimeout = true;
                return InspectionResult.newBuilder().decision(InspectionDecision.Retry).description("CommitTimeout").build();
            }
            case WrongExpectedVersion: {
                this.succeed();
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("WrongExpectedVersion").build();
            }
            case StreamDeleted: {
                this.succeed();
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("StreamDeleted").build();
            }
            case InvalidTransaction: {
                this.fail(new InvalidTransactionException());
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("InvalidTransaction").build();
            }
            case AccessDenied: {
                this.fail(new AccessDeniedException(String.format("Write access denied for stream '%s'.", this.stream)));
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("AccessDenied").build();
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected OperationResult: %s.", new Object[]{response.getResult()}));
    }

    @Override
    protected WriteAttemptResult transformResponseMessage(EventStoreClientMessages.WriteEventsCompleted response) {
        WriteStatus status;
        long nextExpectedVersion;
        Position position = null;
        switch (response.getResult()) {
            case WrongExpectedVersion: {
                nextExpectedVersion = -2L;
                status = WriteStatus.WrongExpectedVersion;
                break;
            }
            case StreamDeleted: {
                nextExpectedVersion = -2L;
                status = WriteStatus.StreamDeleted;
                break;
            }
            default: {
                nextExpectedVersion = response.getLastEventNumber();
                long commitPosition = response.hasCommitPosition() ? response.getCommitPosition() : -1L;
                long preparePosition = response.hasPreparePosition() ? response.getPreparePosition() : -1L;
                position = new Position(commitPosition, preparePosition);
                status = WriteStatus.Success;
            }
        }
        return new WriteAttemptResult(nextExpectedVersion, position, status);
    }

    public String toString() {
        return String.format("Stream: %s, ExpectedVersion: %d", this.stream, this.expectedVersion);
    }
}

