/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.operation;

import com.github.msemys.esjc.PersistentSubscriptionSettings;
import com.github.msemys.esjc.PersistentSubscriptionUpdateResult;
import com.github.msemys.esjc.PersistentSubscriptionUpdateStatus;
import com.github.msemys.esjc.UserCredentials;
import com.github.msemys.esjc.operation.AbstractOperation;
import com.github.msemys.esjc.operation.AccessDeniedException;
import com.github.msemys.esjc.operation.InspectionDecision;
import com.github.msemys.esjc.operation.InspectionResult;
import com.github.msemys.esjc.proto.EventStoreClientMessages;
import com.github.msemys.esjc.system.SystemConsumerStrategy;
import com.github.msemys.esjc.tcp.TcpCommand;
import com.google.protobuf.MessageLite;
import java.util.concurrent.CompletableFuture;

public class UpdatePersistentSubscriptionOperation
extends AbstractOperation<PersistentSubscriptionUpdateResult, EventStoreClientMessages.UpdatePersistentSubscriptionCompleted> {
    private final String stream;
    private final String groupName;
    private final PersistentSubscriptionSettings settings;

    public UpdatePersistentSubscriptionOperation(CompletableFuture<PersistentSubscriptionUpdateResult> result, String stream, String groupName, PersistentSubscriptionSettings settings, UserCredentials userCredentials) {
        super(result, TcpCommand.UpdatePersistentSubscription, TcpCommand.UpdatePersistentSubscriptionCompleted, userCredentials);
        this.stream = stream;
        this.groupName = groupName;
        this.settings = settings;
    }

    @Override
    protected MessageLite createRequestMessage() {
        return EventStoreClientMessages.UpdatePersistentSubscription.newBuilder().setSubscriptionGroupName(this.groupName).setEventStreamId(this.stream).setResolveLinkTos(this.settings.resolveLinkTos).setStartFrom(this.settings.startFrom).setMessageTimeoutMilliseconds((int)this.settings.messageTimeout.toMillis()).setRecordStatistics(this.settings.timingStatistics).setReadBatchSize(this.settings.readBatchSize).setMaxRetryCount(this.settings.maxRetryCount).setLiveBufferSize(this.settings.liveBufferSize).setBufferSize(this.settings.historyBufferSize).setPreferRoundRobin(this.settings.namedConsumerStrategy == SystemConsumerStrategy.ROUND_ROBIN).setCheckpointAfterTime((int)this.settings.checkPointAfter.toMillis()).setCheckpointMinCount(this.settings.minCheckPointCount).setCheckpointMaxCount(this.settings.maxCheckPointCount).setSubscriberMaxCount(this.settings.maxSubscriberCount).setNamedConsumerStrategy(this.settings.namedConsumerStrategy.value).build();
    }

    @Override
    protected EventStoreClientMessages.UpdatePersistentSubscriptionCompleted createResponseMessage() {
        return EventStoreClientMessages.UpdatePersistentSubscriptionCompleted.getDefaultInstance();
    }

    @Override
    protected InspectionResult inspectResponseMessage(EventStoreClientMessages.UpdatePersistentSubscriptionCompleted response) {
        switch (response.getResult()) {
            case Success: {
                this.succeed();
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("Success").build();
            }
            case Fail: {
                this.fail(new IllegalStateException(String.format("Subscription group %s on stream %s failed '%s'", this.groupName, this.stream, response.getReason())));
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("Fail").build();
            }
            case AccessDenied: {
                this.fail(new AccessDeniedException(String.format("Write access denied for stream '%s'.", this.stream)));
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("AccessDenied").build();
            }
            case DoesNotExist: {
                this.fail(new IllegalStateException(String.format("Subscription group %s on stream %s does not exist", this.groupName, this.stream)));
                return InspectionResult.newBuilder().decision(InspectionDecision.EndOperation).description("DoesNotExist").build();
            }
        }
        throw new IllegalArgumentException("Unexpected OperationResult: " + (Object)((Object)response.getResult()));
    }

    @Override
    protected PersistentSubscriptionUpdateResult transformResponseMessage(EventStoreClientMessages.UpdatePersistentSubscriptionCompleted response) {
        return new PersistentSubscriptionUpdateResult(PersistentSubscriptionUpdateStatus.Success);
    }

    public String toString() {
        return String.format("Stream: %s, Group Name: %s", this.stream, this.groupName);
    }
}

