/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.operation.manager;

import com.github.msemys.esjc.operation.Operation;
import com.github.msemys.esjc.util.Preconditions;
import com.github.msemys.esjc.util.SystemTime;
import io.netty.channel.ChannelId;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class OperationItem
implements Comparable<OperationItem> {
    private static final AtomicLong sequencer = new AtomicLong(-1L);
    public final long sequenceNo = sequencer.incrementAndGet();
    public final Operation operation;
    public final int maxRetries;
    public final Duration timeout;
    public final Instant createdTime;
    public ChannelId connectionId;
    public UUID correlationId;
    public int retryCount;
    public final SystemTime lastUpdated;

    public OperationItem(Operation operation, int maxRetries, Duration timeout) {
        Preconditions.checkNotNull(operation, "operation is null");
        this.operation = operation;
        this.maxRetries = maxRetries;
        this.timeout = timeout;
        this.createdTime = Instant.now();
        this.correlationId = UUID.randomUUID();
        this.retryCount = 0;
        this.lastUpdated = SystemTime.now();
    }

    @Override
    public int compareTo(OperationItem o) {
        if (this.sequenceNo < o.sequenceNo) {
            return -1;
        }
        if (this.sequenceNo > o.sequenceNo) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Operation (").append(this.operation.getClass().getSimpleName()).append("): ");
        sb.append(this.correlationId).append(", retry count: ").append(this.retryCount).append(", ");
        sb.append("created: ").append(this.createdTime).append(", ");
        sb.append("last updated: ").append(this.lastUpdated);
        return sb.toString();
    }
}

