/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.projection;

import com.github.msemys.esjc.projection.ProjectionMode;
import com.github.msemys.esjc.util.Preconditions;

public class CreateOptions {
    public static final CreateOptions TRANSIENT = CreateOptions.newBuilder().mode(ProjectionMode.TRANSIENT).build();
    public static final CreateOptions ONE_TIME = CreateOptions.newBuilder().mode(ProjectionMode.ONE_TIME).build();
    public static final CreateOptions CONTINUOUS = CreateOptions.newBuilder().mode(ProjectionMode.CONTINUOUS).emit(true).build();
    public final ProjectionMode mode;
    public final boolean enabled;
    public final boolean checkpoints;
    public final boolean emit;
    public final boolean trackEmittedStreams;

    private CreateOptions(Builder builder) {
        this.mode = builder.mode;
        this.enabled = builder.enabled;
        this.checkpoints = builder.checkpoints;
        this.emit = builder.emit;
        this.trackEmittedStreams = builder.trackEmittedStreams;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CreateOptions{");
        sb.append("mode=").append((Object)this.mode);
        sb.append(", enabled=").append(this.enabled);
        sb.append(", checkpoints=").append(this.checkpoints);
        sb.append(", emit=").append(this.emit);
        sb.append(", trackEmittedStreams=").append(this.trackEmittedStreams);
        sb.append('}');
        return sb.toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private ProjectionMode mode;
        private Boolean enabled;
        private Boolean checkpoints;
        private Boolean emit;
        private Boolean trackEmittedStreams;

        public Builder mode(ProjectionMode mode) {
            this.mode = mode;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder checkpoints(boolean enabled) {
            this.checkpoints = enabled;
            return this;
        }

        public Builder emit(boolean enabled) {
            this.emit = enabled;
            return this;
        }

        public Builder trackEmittedStreams(boolean enabled) {
            this.trackEmittedStreams = enabled;
            return this;
        }

        public CreateOptions build() {
            Preconditions.checkNotNull(this.mode, "mode is null");
            if (this.enabled == null) {
                this.enabled = true;
            }
            if (this.checkpoints == null) {
                this.checkpoints = false;
            }
            if (this.emit == null) {
                this.emit = false;
            }
            if (this.trackEmittedStreams == null) {
                this.trackEmittedStreams = false;
            }
            return new CreateOptions(this);
        }
    }
}

