/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.projection;

import com.github.msemys.esjc.UserCredentials;
import com.github.msemys.esjc.projection.CreateOptions;
import com.github.msemys.esjc.projection.DeleteOptions;
import com.github.msemys.esjc.projection.Projection;
import com.github.msemys.esjc.projection.ProjectionMode;
import com.github.msemys.esjc.projection.UpdateOptions;
import com.github.msemys.esjc.util.Preconditions;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;

public interface ProjectionManager {
    default public CompletableFuture<Void> enable(String name) {
        return this.enable(name, null);
    }

    public CompletableFuture<Void> enable(String var1, UserCredentials var2);

    default public CompletableFuture<Void> disable(String name) {
        return this.disable(name, null);
    }

    public CompletableFuture<Void> disable(String var1, UserCredentials var2);

    default public CompletableFuture<Void> abort(String name) {
        return this.abort(name, null);
    }

    public CompletableFuture<Void> abort(String var1, UserCredentials var2);

    default public CompletableFuture<Void> reset(String name) {
        return this.reset(name, null);
    }

    public CompletableFuture<Void> reset(String var1, UserCredentials var2);

    default public CompletableFuture<Void> create(String name, String query, ProjectionMode mode) {
        return this.create(name, query, mode, null);
    }

    default public CompletableFuture<Void> create(String name, String query, ProjectionMode mode, UserCredentials userCredentials) {
        CreateOptions options;
        Preconditions.checkNotNull(mode, "mode is null");
        switch (mode) {
            case TRANSIENT: {
                options = CreateOptions.TRANSIENT;
                break;
            }
            case ONE_TIME: {
                options = CreateOptions.ONE_TIME;
                break;
            }
            case CONTINUOUS: {
                options = CreateOptions.CONTINUOUS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported projection mode: " + (Object)((Object)mode));
            }
        }
        return this.create(name, query, options, userCredentials);
    }

    default public CompletableFuture<Void> create(String name, String query, CreateOptions options) {
        return this.create(name, query, options, null);
    }

    public CompletableFuture<Void> create(String var1, String var2, CreateOptions var3, UserCredentials var4);

    default public CompletableFuture<List<Projection>> findAll() {
        return this.findAll(null);
    }

    public CompletableFuture<List<Projection>> findAll(UserCredentials var1);

    default public CompletableFuture<List<Projection>> findByMode(ProjectionMode mode) {
        return this.findByMode(mode, null);
    }

    public CompletableFuture<List<Projection>> findByMode(ProjectionMode var1, UserCredentials var2);

    default public CompletableFuture<Projection> getStatus(String name) {
        return this.getStatus(name, null);
    }

    public CompletableFuture<Projection> getStatus(String var1, UserCredentials var2);

    default public CompletableFuture<String> getState(String name) {
        return this.getState(name, null);
    }

    public CompletableFuture<String> getState(String var1, UserCredentials var2);

    default public CompletableFuture<String> getPartitionState(String name, String partition) {
        return this.getPartitionState(name, partition, null);
    }

    public CompletableFuture<String> getPartitionState(String var1, String var2, UserCredentials var3);

    default public CompletableFuture<String> getResult(String name) {
        return this.getResult(name, null);
    }

    public CompletableFuture<String> getResult(String var1, UserCredentials var2);

    default public CompletableFuture<String> getPartitionResult(String name, String partition) {
        return this.getPartitionResult(name, partition, null);
    }

    public CompletableFuture<String> getPartitionResult(String var1, String var2, UserCredentials var3);

    default public CompletableFuture<String> getStatistics(String name) {
        return this.getStatistics(name, null);
    }

    public CompletableFuture<String> getStatistics(String var1, UserCredentials var2);

    default public CompletableFuture<String> getQuery(String name) {
        return this.getQuery(name, null);
    }

    public CompletableFuture<String> getQuery(String var1, UserCredentials var2);

    default public CompletableFuture<Void> update(String name, String query) {
        return this.update(name, query, (UserCredentials)null);
    }

    default public CompletableFuture<Void> update(String name, String query, UserCredentials userCredentials) {
        return this.update(name, query, UpdateOptions.QUERY_ONLY, userCredentials);
    }

    default public CompletableFuture<Void> update(String name, String query, UpdateOptions options) {
        return this.update(name, query, options, null);
    }

    public CompletableFuture<Void> update(String var1, String var2, UpdateOptions var3, UserCredentials var4);

    default public CompletableFuture<Void> delete(String name) {
        return this.delete(name, DeleteOptions.PROJECTION_ONLY, null);
    }

    default public CompletableFuture<Void> delete(String name, UserCredentials userCredentials) {
        return this.delete(name, DeleteOptions.PROJECTION_ONLY, userCredentials);
    }

    default public CompletableFuture<Void> delete(String name, DeleteOptions options) {
        return this.delete(name, options, null);
    }

    public CompletableFuture<Void> delete(String var1, DeleteOptions var2, UserCredentials var3);

    default public boolean awaitStatus(String name, Predicate<Projection> matcher, Duration timeout) {
        return this.awaitStatus(name, matcher, Duration.ofSeconds(1L), timeout);
    }

    default public boolean awaitStatus(String name, Predicate<Projection> matcher, Duration timeout, UserCredentials userCredentials) {
        return this.awaitStatus(name, matcher, Duration.ofSeconds(1L), timeout, userCredentials);
    }

    default public boolean awaitStatus(String name, Predicate<Projection> matcher, Duration interval, Duration timeout) {
        return this.awaitStatus(name, matcher, interval, timeout, null);
    }

    public boolean awaitStatus(String var1, Predicate<Projection> var2, Duration var3, Duration var4, UserCredentials var5);

    public void shutdown();
}

