/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.projection;

import com.github.msemys.esjc.UserCredentials;
import com.github.msemys.esjc.http.HttpClient;
import com.github.msemys.esjc.projection.ProjectionManager;
import com.github.msemys.esjc.projection.ProjectionManagerHttp;
import java.net.InetSocketAddress;
import java.time.Duration;

public class ProjectionManagerBuilder {
    private final HttpClient.Builder httpClientBuilder = HttpClient.newBuilder();
    private UserCredentials userCredentials;

    private ProjectionManagerBuilder() {
    }

    public static ProjectionManagerBuilder newBuilder() {
        return new ProjectionManagerBuilder();
    }

    public ProjectionManagerBuilder address(String host, int port) {
        this.httpClientBuilder.address(host, port);
        return this;
    }

    public ProjectionManagerBuilder address(InetSocketAddress address) {
        this.httpClientBuilder.address(address);
        return this;
    }

    public ProjectionManagerBuilder connectTimeout(Duration connectTimeout) {
        this.httpClientBuilder.connectTimeout(connectTimeout);
        return this;
    }

    public ProjectionManagerBuilder operationTimeout(Duration operationTimeout) {
        this.httpClientBuilder.operationTimeout(operationTimeout);
        return this;
    }

    public ProjectionManagerBuilder maxContentLength(int maxContentLength) {
        this.httpClientBuilder.maxContentLength(maxContentLength);
        return this;
    }

    public ProjectionManagerBuilder userCredentials(UserCredentials userCredentials) {
        this.userCredentials = userCredentials;
        return this;
    }

    public ProjectionManagerBuilder userCredentials(String username, String password) {
        return this.userCredentials(new UserCredentials(username, password));
    }

    public ProjectionManagerBuilder noUserCredentials() {
        return this.userCredentials(null);
    }

    public ProjectionManager build() {
        return new ProjectionManagerHttp(this.httpClientBuilder.build(), this.userCredentials);
    }
}

