/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.projection;

import com.github.msemys.esjc.UserCredentials;
import com.github.msemys.esjc.http.HttpClient;
import com.github.msemys.esjc.projection.CreateOptions;
import com.github.msemys.esjc.projection.DeleteOptions;
import com.github.msemys.esjc.projection.Projection;
import com.github.msemys.esjc.projection.ProjectionConflictException;
import com.github.msemys.esjc.projection.ProjectionException;
import com.github.msemys.esjc.projection.ProjectionManager;
import com.github.msemys.esjc.projection.ProjectionMode;
import com.github.msemys.esjc.projection.ProjectionNotFoundException;
import com.github.msemys.esjc.projection.Projections;
import com.github.msemys.esjc.projection.UpdateOptions;
import com.github.msemys.esjc.util.Preconditions;
import com.github.msemys.esjc.util.Strings;
import com.github.msemys.esjc.util.concurrent.DefaultThreadFactory;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringEncoder;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectionManagerHttp
implements ProjectionManager {
    private static final Logger logger = LoggerFactory.getLogger(ProjectionManagerHttp.class);
    private static final Gson gson = new GsonBuilder().create();
    private final HttpClient client;
    private final UserCredentials userCredentials;
    private final Timer timer = new HashedWheelTimer((ThreadFactory)new DefaultThreadFactory("es-pm-timer"), 200L, TimeUnit.MILLISECONDS);

    protected ProjectionManagerHttp(HttpClient client, UserCredentials userCredentials) {
        Preconditions.checkNotNull(client, "client is null");
        this.client = client;
        this.userCredentials = userCredentials;
    }

    @Override
    public CompletableFuture<Void> enable(String name, UserCredentials userCredentials) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        return this.post(ProjectionManagerHttp.projectionUri(name) + "/command/enable", "", userCredentials, HttpResponseStatus.OK);
    }

    @Override
    public CompletableFuture<Void> disable(String name, UserCredentials userCredentials) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        return this.post(ProjectionManagerHttp.projectionUri(name) + "/command/disable", "", userCredentials, HttpResponseStatus.OK);
    }

    @Override
    public CompletableFuture<Void> abort(String name, UserCredentials userCredentials) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        return this.post(ProjectionManagerHttp.projectionUri(name) + "/command/abort", "", userCredentials, HttpResponseStatus.OK);
    }

    @Override
    public CompletableFuture<Void> reset(String name, UserCredentials userCredentials) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        return this.post(ProjectionManagerHttp.projectionUri(name) + "/command/reset", "", userCredentials, HttpResponseStatus.OK);
    }

    @Override
    public CompletableFuture<Void> create(String name, String query, CreateOptions options, UserCredentials userCredentials) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(query), "query is null or empty");
        Preconditions.checkNotNull(options, "options is null");
        QueryStringEncoder queryStringEncoder = new QueryStringEncoder(ProjectionManagerHttp.projectionsUri(options.mode));
        queryStringEncoder.addParam("name", name);
        queryStringEncoder.addParam("type", "JS");
        queryStringEncoder.addParam("enabled", Boolean.toString(options.enabled));
        switch (options.mode) {
            case ONE_TIME: {
                queryStringEncoder.addParam("checkpoints", Boolean.toString(options.checkpoints));
            }
            case CONTINUOUS: {
                queryStringEncoder.addParam("emit", Boolean.toString(options.emit));
                queryStringEncoder.addParam("trackemittedstreams", Boolean.toString(options.trackEmittedStreams));
            }
        }
        return this.post(queryStringEncoder.toString(), query, userCredentials, HttpResponseStatus.CREATED);
    }

    @Override
    public CompletableFuture<List<Projection>> findAll(UserCredentials userCredentials) {
        return this.get("/projections/any", userCredentials, HttpResponseStatus.OK).thenApply(ProjectionManagerHttp::asProjectionList);
    }

    @Override
    public CompletableFuture<List<Projection>> findByMode(ProjectionMode mode, UserCredentials userCredentials) {
        Preconditions.checkNotNull(mode, "mode is null");
        return this.get(ProjectionManagerHttp.projectionsUri(mode), userCredentials, HttpResponseStatus.OK).thenApply(ProjectionManagerHttp::asProjectionList);
    }

    @Override
    public CompletableFuture<Projection> getStatus(String name, UserCredentials userCredentials) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        return this.get(ProjectionManagerHttp.projectionUri(name), userCredentials, HttpResponseStatus.OK).thenApply(ProjectionManagerHttp::asProjection);
    }

    @Override
    public CompletableFuture<String> getState(String name, UserCredentials userCredentials) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        return this.get(ProjectionManagerHttp.projectionUri(name) + "/state", userCredentials, HttpResponseStatus.OK);
    }

    @Override
    public CompletableFuture<String> getPartitionState(String name, String partition, UserCredentials userCredentials) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(partition), "partition is null or empty");
        return this.get(ProjectionManagerHttp.projectionUri(name) + "/state?partition=" + partition, userCredentials, HttpResponseStatus.OK);
    }

    @Override
    public CompletableFuture<String> getResult(String name, UserCredentials userCredentials) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        return this.get(ProjectionManagerHttp.projectionUri(name) + "/result", userCredentials, HttpResponseStatus.OK);
    }

    @Override
    public CompletableFuture<String> getPartitionResult(String name, String partition, UserCredentials userCredentials) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(partition), "partition is null or empty");
        return this.get(ProjectionManagerHttp.projectionUri(name) + "/result?partition=" + partition, userCredentials, HttpResponseStatus.OK);
    }

    @Override
    public CompletableFuture<String> getStatistics(String name, UserCredentials userCredentials) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        return this.get(ProjectionManagerHttp.projectionUri(name) + "/statistics", userCredentials, HttpResponseStatus.OK);
    }

    @Override
    public CompletableFuture<String> getQuery(String name, UserCredentials userCredentials) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        return this.get(ProjectionManagerHttp.projectionUri(name) + "/query", userCredentials, HttpResponseStatus.OK);
    }

    @Override
    public CompletableFuture<Void> update(String name, String query, UpdateOptions options, UserCredentials userCredentials) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(query), "query is null or empty");
        Preconditions.checkNotNull(options, "options is null");
        QueryStringEncoder queryStringEncoder = new QueryStringEncoder(ProjectionManagerHttp.projectionUri(name) + "/query");
        queryStringEncoder.addParam("type", "JS");
        if (options.emit != null) {
            queryStringEncoder.addParam("emit", Boolean.toString(options.emit));
        }
        return this.put(queryStringEncoder.toString(), query, userCredentials, HttpResponseStatus.OK);
    }

    @Override
    public CompletableFuture<Void> delete(String name, DeleteOptions options, UserCredentials userCredentials) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        Preconditions.checkNotNull(options, "options is null");
        QueryStringEncoder queryStringEncoder = new QueryStringEncoder(ProjectionManagerHttp.projectionUri(name));
        queryStringEncoder.addParam("deleteStateStream", Boolean.toString(options.deleteStateStream));
        queryStringEncoder.addParam("deleteCheckpointStream", Boolean.toString(options.deleteCheckpointStream));
        queryStringEncoder.addParam("deleteEmittedStreams", Boolean.toString(options.deleteEmittedStreams));
        return this.delete(queryStringEncoder.toString(), userCredentials, HttpResponseStatus.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitStatus(final String name, final Predicate<Projection> matcher, final Duration interval, Duration timeout, final UserCredentials userCredentials) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        Preconditions.checkNotNull(matcher, "matcher is null");
        Preconditions.checkNotNull(interval, "interval is null");
        Preconditions.checkNotNull(timeout, "timeout is null");
        Preconditions.checkArgument(interval.compareTo(timeout) < 0, "interval can not be longer than timeout");
        if (((Boolean)((CompletableFuture)this.getStatus(name, userCredentials).thenApply(matcher::test)).join()).booleanValue()) {
            return true;
        }
        final CountDownLatch barrier = new CountDownLatch(1);
        final AtomicBoolean waitingTimeElapsed = new AtomicBoolean();
        final AtomicReference<Timeout> scheduledTimeout = new AtomicReference<Timeout>();
        TimerTask timerTask = new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                if (!waitingTimeElapsed.get()) {
                    ((CompletableFuture)((CompletableFuture)ProjectionManagerHttp.this.getStatus(name, userCredentials).thenApply(matcher::test)).exceptionally(e -> {
                        logger.error("Error occurred while pulling '{}' projection status", (Object)name, e);
                        return false;
                    })).thenAccept(matches -> {
                        if (matches.booleanValue()) {
                            barrier.countDown();
                        } else if (!waitingTimeElapsed.get()) {
                            scheduledTimeout.set(ProjectionManagerHttp.this.timer.newTimeout((TimerTask)this, interval.toMillis(), TimeUnit.MILLISECONDS));
                        }
                    });
                }
            }
        };
        scheduledTimeout.set(this.timer.newTimeout(timerTask, interval.toMillis(), TimeUnit.MILLISECONDS));
        try {
            boolean bl = barrier.await(timeout.toMillis(), TimeUnit.MILLISECONDS);
            return bl;
        }
        catch (InterruptedException e) {
            logger.error("Interrupted while waiting '{}' projection status", (Object)name, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            waitingTimeElapsed.set(true);
            ((Timeout)scheduledTimeout.get()).cancel();
        }
    }

    @Override
    public void shutdown() {
        this.timer.stop();
        this.client.close();
    }

    private CompletableFuture<String> get(String uri, UserCredentials userCredentials, HttpResponseStatus expectedStatus) {
        FullHttpRequest request = HttpClient.newRequest(HttpMethod.GET, uri, this.defaultOr(userCredentials));
        return this.client.send((HttpRequest)request).thenApply(response -> {
            if (response.status().code() == expectedStatus.code()) {
                return response.content().toString(StandardCharsets.UTF_8);
            }
            if (response.status().code() == HttpResponseStatus.NOT_FOUND.code()) {
                throw new ProjectionNotFoundException((HttpRequest)request, (FullHttpResponse)response);
            }
            throw new ProjectionException((HttpRequest)request, (FullHttpResponse)response);
        });
    }

    private CompletableFuture<Void> delete(String uri, UserCredentials userCredentials, HttpResponseStatus expectedStatus) {
        FullHttpRequest request = HttpClient.newRequest(HttpMethod.DELETE, uri, this.defaultOr(userCredentials));
        return this.client.send((HttpRequest)request).thenAccept(response -> {
            if (response.status().code() == HttpResponseStatus.NOT_FOUND.code()) {
                throw new ProjectionNotFoundException((HttpRequest)request, (FullHttpResponse)response);
            }
            if (response.status().code() != expectedStatus.code()) {
                throw new ProjectionException((HttpRequest)request, (FullHttpResponse)response);
            }
        });
    }

    private CompletableFuture<Void> put(String uri, String content, UserCredentials userCredentials, HttpResponseStatus expectedStatus) {
        FullHttpRequest request = HttpClient.newRequest(HttpMethod.PUT, uri, content, (CharSequence)HttpHeaderValues.APPLICATION_JSON, this.defaultOr(userCredentials));
        return this.client.send((HttpRequest)request).thenAccept(response -> {
            if (response.status().code() == HttpResponseStatus.NOT_FOUND.code()) {
                throw new ProjectionNotFoundException((HttpRequest)request, (FullHttpResponse)response);
            }
            if (response.status().code() != expectedStatus.code()) {
                throw new ProjectionException((HttpRequest)request, (FullHttpResponse)response);
            }
        });
    }

    private CompletableFuture<Void> post(String uri, String content, UserCredentials userCredentials, HttpResponseStatus expectedStatus) {
        FullHttpRequest request = HttpClient.newRequest(HttpMethod.POST, uri, content, (CharSequence)HttpHeaderValues.APPLICATION_JSON, this.defaultOr(userCredentials));
        return this.client.send((HttpRequest)request).thenAccept(response -> {
            if (response.status().code() == HttpResponseStatus.NOT_FOUND.code()) {
                throw new ProjectionNotFoundException((HttpRequest)request, (FullHttpResponse)response);
            }
            if (response.status().code() == HttpResponseStatus.CONFLICT.code()) {
                throw new ProjectionConflictException((HttpRequest)request, (FullHttpResponse)response);
            }
            if (response.status().code() != expectedStatus.code()) {
                throw new ProjectionException((HttpRequest)request, (FullHttpResponse)response);
            }
        });
    }

    private UserCredentials defaultOr(UserCredentials userCredentials) {
        return userCredentials == null ? this.userCredentials : userCredentials;
    }

    private static List<Projection> asProjectionList(String json) {
        if (Strings.isNullOrEmpty(json)) {
            return Collections.emptyList();
        }
        Projections projections = (Projections)gson.fromJson(json, Projections.class);
        return projections.projections != null ? projections.projections : Collections.emptyList();
    }

    private static Projection asProjection(String json) {
        return Strings.isNullOrEmpty(json) ? null : (Projection)gson.fromJson(json, Projection.class);
    }

    private static String projectionUri(String name) {
        return "/projection/" + name.trim();
    }

    private static String projectionsUri(ProjectionMode mode) {
        switch (mode) {
            case TRANSIENT: {
                return "/projections/transient";
            }
            case ONE_TIME: {
                return "/projections/onetime";
            }
            case CONTINUOUS: {
                return "/projections/continuous";
            }
        }
        throw new IllegalArgumentException("Unsupported projection mode: " + (Object)((Object)mode));
    }
}

