/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.ssl;

import com.github.msemys.esjc.util.Preconditions;
import com.github.msemys.esjc.util.Strings;
import io.netty.handler.ssl.util.SimpleTrustManagerFactory;
import io.netty.util.internal.EmptyArrays;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonNameTrustManagerFactory
extends SimpleTrustManagerFactory {
    private static final Logger logger = LoggerFactory.getLogger(CommonNameTrustManagerFactory.class);
    private final TrustManager tm = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.checkTrusted("client", chain);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.checkTrusted("server", chain);
        }

        private void checkTrusted(String type, X509Certificate[] chain) throws CertificateException {
            if (chain == null || chain.length == 0) {
                throw new CertificateException(type + " certificate not available");
            }
            X509Certificate certificate = chain[0];
            logger.debug("Accepting a {} certificate: {}", (Object)type, (Object)certificate.getSubjectX500Principal().getName());
            try {
                certificate.checkValidity();
            }
            catch (Exception e) {
                throw new CertificateException(type + " certificate has expired");
            }
            try {
                LdapName names = new LdapName(certificate.getSubjectX500Principal().getName());
                for (Rdn name : names.getRdns()) {
                    if (!name.getType().equalsIgnoreCase("CN")) continue;
                    if (CommonNameTrustManagerFactory.this.commonName.equals(name.getValue())) break;
                    throw new CertificateException(type + " certificate common name (CN) mismatch");
                }
            }
            catch (InvalidNameException e) {
                throw new CertificateException(type + " certificate not trusted", e);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return EmptyArrays.EMPTY_X509_CERTIFICATES;
        }
    };
    private final String commonName;

    public CommonNameTrustManagerFactory(String commonName) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(commonName), "commonName is null or empty");
        this.commonName = commonName;
    }

    protected void engineInit(KeyStore keyStore) throws Exception {
    }

    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws Exception {
    }

    protected TrustManager[] engineGetTrustManagers() {
        return new TrustManager[]{this.tm};
    }
}

