/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.ssl;

import com.github.msemys.esjc.ssl.SslValidationMode;
import com.github.msemys.esjc.util.Preconditions;
import com.github.msemys.esjc.util.Strings;
import java.io.File;

public class SslSettings {
    private static final SslSettings TRUST_ALL_CERTIFICATES = new SslSettings(true, SslValidationMode.NONE, null, null);
    private static final SslSettings NO_SSL = new SslSettings(false, SslValidationMode.NONE, null, null);
    public final boolean useSslConnection;
    public final String certificateCommonName;
    public final File certificateFile;
    public final SslValidationMode validationMode;

    private SslSettings(boolean useSslConnection, SslValidationMode validationMode, String certificateCommonName, File certificateFile) {
        this.useSslConnection = useSslConnection;
        this.certificateCommonName = certificateCommonName;
        this.validationMode = validationMode;
        this.certificateFile = certificateFile;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SslSettings{");
        sb.append("useSslConnection=").append(this.useSslConnection);
        sb.append(", validationMode=").append((Object)this.validationMode);
        sb.append(", certificateCommonName='").append(this.certificateCommonName).append('\'');
        sb.append(", certificateFile=").append(this.certificateFile);
        sb.append('}');
        return sb.toString();
    }

    public static SslSettings trustCertificateCN(String certificateCommonName) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(certificateCommonName), "certificateCommonName is null or empty");
        return new SslSettings(true, SslValidationMode.COMMON_NAME, certificateCommonName, null);
    }

    public static SslSettings trustCertificate(File certificateFile) {
        Preconditions.checkArgument(certificateFile != null, "certificateFile is null");
        Preconditions.checkArgument(certificateFile.exists(), "certificateFile '" + certificateFile + "' does not exist");
        return new SslSettings(true, SslValidationMode.CERTIFICATE, null, certificateFile);
    }

    public static SslSettings trustAllCertificates() {
        return TRUST_ALL_CERTIFICATES;
    }

    public static SslSettings noSsl() {
        return NO_SSL;
    }
}

