/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.subscription;

import com.github.msemys.esjc.RetryableResolvedEvent;
import com.github.msemys.esjc.Subscription;
import com.github.msemys.esjc.SubscriptionDropReason;
import com.github.msemys.esjc.SubscriptionListener;
import com.github.msemys.esjc.UserCredentials;
import com.github.msemys.esjc.operation.AccessDeniedException;
import com.github.msemys.esjc.operation.InspectionDecision;
import com.github.msemys.esjc.operation.InspectionResult;
import com.github.msemys.esjc.proto.EventStoreClientMessages;
import com.github.msemys.esjc.subscription.AbstractSubscriptionOperation;
import com.github.msemys.esjc.subscription.MaximumSubscribersReachedException;
import com.github.msemys.esjc.subscription.PersistentSubscriptionChannel;
import com.github.msemys.esjc.subscription.PersistentSubscriptionDeletedException;
import com.github.msemys.esjc.subscription.PersistentSubscriptionNakEventAction;
import com.github.msemys.esjc.subscription.PersistentSubscriptionProtocol;
import com.github.msemys.esjc.tcp.TcpCommand;
import com.github.msemys.esjc.tcp.TcpFlag;
import com.github.msemys.esjc.tcp.TcpPackage;
import com.github.msemys.esjc.util.Preconditions;
import com.github.msemys.esjc.util.UUIDConverter;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class PersistentSubscriptionOperation
extends AbstractSubscriptionOperation<PersistentSubscriptionChannel, RetryableResolvedEvent>
implements PersistentSubscriptionProtocol {
    private final String groupName;
    private final int bufferSize;
    private String subscriptionId;

    public PersistentSubscriptionOperation(CompletableFuture<Subscription> result, String groupName, String streamId, int bufferSize, UserCredentials userCredentials, SubscriptionListener<PersistentSubscriptionChannel, RetryableResolvedEvent> listener, Supplier<Channel> connectionSupplier, Executor executor) {
        super(result, TcpCommand.ConnectToPersistentSubscription, streamId, false, userCredentials, listener, connectionSupplier, executor);
        this.groupName = groupName;
        this.bufferSize = bufferSize;
    }

    @Override
    protected MessageLite createSubscribeMessage() {
        return EventStoreClientMessages.ConnectToPersistentSubscription.newBuilder().setSubscriptionId(this.groupName).setEventStreamId(this.streamId).setAllowedInFlightMessages(this.bufferSize).build();
    }

    @Override
    protected PersistentSubscriptionChannel createSubscription(long lastCommitPosition, Long lastEventNumber) {
        return new PersistentSubscriptionChannel(this, this.streamId, lastCommitPosition, lastEventNumber);
    }

    @Override
    protected boolean inspect(TcpPackage tcpPackage, InspectionResult.Builder builder) {
        switch (tcpPackage.command) {
            case PersistentSubscriptionConfirmation: {
                EventStoreClientMessages.PersistentSubscriptionConfirmation confirmation = PersistentSubscriptionOperation.newInstance(EventStoreClientMessages.PersistentSubscriptionConfirmation.getDefaultInstance(), tcpPackage.data);
                this.confirmSubscription(confirmation.getLastCommitPosition(), confirmation.hasLastEventNumber() ? Long.valueOf(confirmation.getLastEventNumber()) : null);
                builder.decision(InspectionDecision.Subscribed).description("SubscriptionConfirmation");
                this.subscriptionId = confirmation.getSubscriptionId();
                return true;
            }
            case PersistentSubscriptionStreamEventAppeared: {
                EventStoreClientMessages.PersistentSubscriptionStreamEventAppeared streamEventAppeared = PersistentSubscriptionOperation.newInstance(EventStoreClientMessages.PersistentSubscriptionStreamEventAppeared.getDefaultInstance(), tcpPackage.data);
                this.eventAppeared(new RetryableResolvedEvent(streamEventAppeared.getEvent(), streamEventAppeared.hasRetryCount() ? Integer.valueOf(streamEventAppeared.getRetryCount()) : null));
                builder.decision(InspectionDecision.DoNothing).description("StreamEventAppeared");
                return true;
            }
            case SubscriptionDropped: {
                EventStoreClientMessages.SubscriptionDropped subscriptionDropped = PersistentSubscriptionOperation.newInstance(EventStoreClientMessages.SubscriptionDropped.getDefaultInstance(), tcpPackage.data);
                switch (subscriptionDropped.getReason()) {
                    case AccessDenied: {
                        this.drop(SubscriptionDropReason.AccessDenied, new AccessDeniedException("You do not have access to the stream."));
                        builder.decision(InspectionDecision.EndOperation).description("SubscriptionDropped");
                        return true;
                    }
                    case NotFound: {
                        this.drop(SubscriptionDropReason.NotFound, new IllegalArgumentException("Subscription not found"));
                        builder.decision(InspectionDecision.EndOperation).description("SubscriptionDropped");
                        return true;
                    }
                    case PersistentSubscriptionDeleted: {
                        this.drop(SubscriptionDropReason.PersistentSubscriptionDeleted, new PersistentSubscriptionDeletedException());
                        builder.decision(InspectionDecision.EndOperation).description("SubscriptionDropped");
                        return true;
                    }
                    case SubscriberMaxCountReached: {
                        this.drop(SubscriptionDropReason.MaxSubscribersReached, new MaximumSubscribersReachedException());
                        builder.decision(InspectionDecision.EndOperation).description("SubscriptionDropped");
                        return true;
                    }
                    case Unsubscribed: {
                        this.drop(SubscriptionDropReason.UserInitiated, null, (Channel)this.connectionSupplier.get());
                        builder.decision(InspectionDecision.EndOperation).description("SubscriptionDropped");
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void notifyEventsProcessed(List<UUID> processedEvents) {
        Preconditions.checkNotNull(processedEvents, "processedEvents is null");
        EventStoreClientMessages.PersistentSubscriptionAckEvents message = EventStoreClientMessages.PersistentSubscriptionAckEvents.newBuilder().setSubscriptionId(this.subscriptionId).addAllProcessedEventIds(processedEvents.stream().map(uuid -> ByteString.copyFrom((byte[])UUIDConverter.toBytes(uuid))).collect(Collectors.toCollection(() -> new ArrayList(processedEvents.size())))).build();
        this.send(TcpPackage.newBuilder().command(TcpCommand.PersistentSubscriptionAckEvents).flag(this.userCredentials != null ? TcpFlag.Authenticated : TcpFlag.None).correlationId(this.correlationId).login(this.userCredentials != null ? this.userCredentials.username : null).password(this.userCredentials != null ? this.userCredentials.password : null).data(message.toByteArray()).build());
    }

    @Override
    public void notifyEventsFailed(List<UUID> processedEvents, PersistentSubscriptionNakEventAction action, String reason) {
        Preconditions.checkNotNull(processedEvents, "processedEvents is null");
        Preconditions.checkNotNull(reason, "reason is null");
        EventStoreClientMessages.PersistentSubscriptionNakEvents message = EventStoreClientMessages.PersistentSubscriptionNakEvents.newBuilder().setSubscriptionId(this.subscriptionId).addAllProcessedEventIds(processedEvents.stream().map(uuid -> ByteString.copyFrom((byte[])UUIDConverter.toBytes(uuid))).collect(Collectors.toCollection(() -> new ArrayList(processedEvents.size())))).setMessage(reason).setAction(EventStoreClientMessages.PersistentSubscriptionNakEvents.NakAction.valueOf(action.name())).build();
        this.send(TcpPackage.newBuilder().command(TcpCommand.PersistentSubscriptionNakEvents).flag(this.userCredentials != null ? TcpFlag.Authenticated : TcpFlag.None).correlationId(this.correlationId).login(this.userCredentials != null ? this.userCredentials.username : null).password(this.userCredentials != null ? this.userCredentials.password : null).data(message.toByteArray()).build());
    }
}

